<?php

/**
 * @package         Convert Forms
 * @version         3.2.9 Free
 * 
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2022 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace ConvertForms\Field;

use Joomla\CMS\Factory;
use NRFramework\Executer;

defined('_JEXEC') or die('Restricted access');

class Captcha extends Text
{
	/**
	 *  Exclude all common fields
	 *
	 *  @var  mixed
	 */
	protected $excludeFields = [
		'name',
		'required',
		'size',
		'value',
		'placeholder',
		'browserautocomplete',
		'inputcssclass'
	];

	/**
	 * This is bullshit. We should call setField() in the Field's Class constructor so we can access the field object correctly. Consider this as a workround.
	 *
	 * @return string
	 */
	private function getFieldID()
	{
		$field = get_class($this->field) == 'Joomla\Registry\Registry' ? $this->field->toObject() : $this->field;
		return $field->key;
	}

	/**
	 * This is bullshit. We should call setField() in the Field's Class constructor so we can access the field's ID correctly. Consider this as a workround.
	 *
	 * @return string
	 */
	private function getSessionNamespace()
	{
		return 'cf.' . $this->getFieldID() . '.captcha';
	}

	/**
	 *  Set field object
	 *
	 *  @param  mixed  $field  Object or Array Field options
	 */
	public function setField($field)
	{
		parent::setField($field);

		// Once we start calling $this->setField() in the constructo, we can get rid of this line.
		$this->field->required = true;

		// Pick random numbers
		$number1 = rand(1, 20);
		$number2 = rand(1, 20);

		// Pick a random math comparison operator
		$comparators = ['+', '-'];
		shuffle($comparators);
		$comparator = end($comparators);
		
		// Calculate the Captcha answer
		$equation = "return ($number1 $comparator $number2)";
		$executer = new Executer($equation);
		$answer = $executer->run();
		
		// Store the Captcha answer in the Session object.
        Factory::getSession()->set($this->getSessionNamespace(), $answer);

		// Pass data to template
		$this->field->question = [
			'number1'    => $number1,
			'number2'    => $number2,
			'comparator' => $comparator,
		];;

		return $this;
	}

	/**
	 *  Validate field value
	 *
	 *  @param   mixed  $value           The field's value to validate
	 *
	 *  @return  mixed                   True on success, throws an exception on error
	 */
	public function validate(&$value)
	{
		// In case this is a submission via URL, skip the check.
		if (\JFactory::getApplication()->input->get('task') == 'optin')
		{
			return true;
		}

		$math_solution = (int) Factory::getSession()->get($this->getSessionNamespace());

		// Once we start calling $this->setField() in the constructor we can easily find the field's name by using $this->field->name instead of relying on the submitted data.
		$user_solution = (int) $this->data['captcha_' . $this->getFieldID()];

		if ($math_solution !== $user_solution)
		{
			$this->throwError(\JText::_('COM_CONVERTFORMS_FIELD_CAPTCHA_WRONG_ANSWER'));
		}
	}
}

?>