SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE IF NOT EXISTS `#__action_logs` (
`id` int(10) unsigned NOT NULL,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE IF NOT EXISTS `#__action_logs_extensions` (
`id` int(10) unsigned NOT NULL,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE IF NOT EXISTS `#__action_logs_users` (
  `user_id` int(11) unsigned NOT NULL,
  `notify` tinyint(1) unsigned NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE IF NOT EXISTS `#__action_log_config` (
`id` int(10) unsigned NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
`id` int(10) unsigned NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=210 ;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 656, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 18, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(8, 1, 19, 108, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 109, 110, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 111, 112, 1, 'com_installer', 'com_installer', '{"core.admin":{"7":1},"core.manage":{"7":1},"core.delete":[],"core.edit.state":[]}'),
(11, 1, 113, 114, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 115, 116, 1, 'com_login', 'com_login', '{}'),
(13, 1, 117, 118, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 119, 120, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 121, 122, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1}}'),
(16, 1, 123, 124, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 125, 126, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 127, 256, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 257, 260, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(20, 1, 261, 262, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 263, 264, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 265, 266, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 267, 268, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 269, 270, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(25, 1, 271, 276, 1, 'com_weblinks', 'com_weblinks', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(26, 1, 277, 278, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 31, 2, 'com_content.category.2', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(30, 19, 258, 259, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(31, 25, 272, 273, 2, 'com_weblinks.category.6', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(32, 8, 32, 43, 2, 'com_content.category.7', 'Blog', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(33, 64, 63, 64, 3, 'com_content.article.1', 'Module Variations', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 64, 61, 62, 3, 'com_content.article.4', 'UiKit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(37, 64, 59, 60, 3, 'com_content.article.5', 'Dummy Content', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(38, 64, 57, 58, 3, 'com_content.article.6', 'Features', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(39, 64, 51, 52, 3, 'com_content.article.7', 'Sticky Menu = Off', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(40, 32, 33, 34, 3, 'com_content.article.8', 'Sample Blog Article', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 32, 35, 36, 3, 'com_content.article.10', 'Sample Blog Article', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(56, 7, 16, 17, 2, 'com_contact.category.8', 'Contacts', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(57, 25, 274, 275, 2, 'com_weblinks.category.9', 'JoomlaPlates Links', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(59, 1, 634, 635, 1, 'com_finder', 'com_finder', '{"core.admin":[],"core.manage":[]}'),
(64, 8, 44, 71, 2, 'com_content.category.10', 'template', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(65, 64, 55, 56, 3, 'com_content.article.24', 'Module Positions', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(66, 32, 39, 40, 3, 'com_content.article.23', 'Sample Blog Article', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(74, 64, 53, 54, 3, 'com_content.article.30', 'Customizer Included', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(76, 27, 29, 30, 3, 'com_content.article.31', '1st Class Joomla Template - Game Style', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(77, 64, 49, 50, 3, 'com_content.article.32', 'Smooth Scroll to any Section', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(78, 64, 47, 48, 3, 'com_content.article.33', 'Sidebar Right', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(79, 64, 45, 46, 3, 'com_content.article.34', 'Sidebar Left', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(80, 32, 41, 42, 3, 'com_content.article.35', 'Sample Blog Article', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(81, 1, 640, 641, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(82, 1, 642, 643, 1, 'com_tags', 'com_tags', '{}'),
(83, 1, 644, 645, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(84, 1, 646, 647, 1, 'com_ajax', 'com_ajax', '{}'),
(85, 1, 648, 649, 1, 'com_postinstall', 'com_postinstall', '{}'),
(87, 18, 128, 129, 2, 'com_modules.module.38', 'Logo', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(88, 1, 650, 651, 1, 'com_roksprocket', 'roksprocket', '{}'),
(89, 18, 130, 131, 2, 'com_modules.module.165', 'RokSprocket Module', ''),
(90, 18, 132, 133, 2, 'com_modules.module.166', 'Home Headerbar Slideshow', '{}'),
(98, 18, 134, 135, 2, 'com_modules.module.35', 'Top B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(99, 18, 136, 137, 2, 'com_modules.module.34', 'Top B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(100, 18, 138, 139, 2, 'com_modules.module.19', 'Top B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(102, 18, 140, 141, 2, 'com_modules.module.40', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(103, 18, 142, 143, 2, 'com_modules.module.170', 'About Us', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(106, 18, 144, 145, 2, 'com_modules.module.173', 'Links', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(107, 18, 146, 147, 2, 'com_modules.module.31', 'Footer  Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(109, 18, 148, 149, 2, 'com_modules.module.130', 'Logo Mobile', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(113, 18, 150, 151, 2, 'com_modules.module.175', 'Template Features', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(114, 18, 152, 153, 2, 'com_modules.module.176', 'Module Features', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(116, 18, 154, 155, 2, 'com_modules.module.42', 'Sidebar Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(117, 18, 156, 157, 2, 'com_modules.module.177', 'Sidebar A', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(122, 18, 158, 159, 2, 'com_modules.module.182', 'Social Icons', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(126, 18, 160, 161, 2, 'com_modules.module.184', 'Top C', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(127, 18, 162, 163, 2, 'com_modules.module.185', 'Top C', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(128, 18, 164, 165, 2, 'com_modules.module.186', 'Top C', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(129, 18, 166, 167, 2, 'com_modules.module.187', 'Bottom B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(130, 18, 168, 169, 2, 'com_modules.module.188', 'Bottom C', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(131, 18, 170, 171, 2, 'com_modules.module.189', 'Bottom A', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(133, 18, 172, 173, 2, 'com_modules.module.190', 'Module Variations', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(134, 18, 174, 175, 2, 'com_modules.module.44', 'Sidebar A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(135, 18, 176, 177, 2, 'com_modules.module.43', 'Sidebar A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(136, 18, 178, 179, 2, 'com_modules.module.163', 'Sidebar B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(137, 18, 180, 181, 2, 'com_modules.module.57', 'Sidebar B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(138, 18, 182, 183, 2, 'com_modules.module.191', 'Sidebar A Right', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(139, 18, 184, 185, 2, 'com_modules.module.192', 'Sidebar A Right', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(143, 18, 186, 187, 2, 'com_modules.module.195', 'Submenu', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(146, 8, 72, 91, 2, 'com_content.category.11', 'Sample Articles', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(147, 146, 73, 74, 3, 'com_content.article.38', 'Demo Article 1', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(148, 146, 75, 76, 3, 'com_content.article.39', 'Demo Article 2', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(156, 18, 190, 191, 2, 'com_modules.module.140', 'Top D', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(149, 146, 77, 78, 3, 'com_content.article.40', 'Demo Article 3', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(150, 146, 79, 80, 3, 'com_content.article.41', 'Demo Article 4', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(151, 146, 81, 82, 3, 'com_content.article.42', 'Demo Article 5', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(152, 146, 83, 84, 3, 'com_content.article.43', 'Demo Article 6', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(153, 146, 85, 86, 3, 'com_content.article.44', 'Demo Article 7', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(154, 146, 87, 88, 3, 'com_content.article.45', 'Demo Article 8', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(155, 18, 188, 189, 2, 'com_modules.module.198', 'Sample Mosaic Gallery', '{}'),
(157, 18, 192, 193, 2, 'com_modules.module.139', 'Top D', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(158, 18, 194, 195, 2, 'com_modules.module.141', 'Top D', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(159, 160, 93, 94, 3, 'com_content.article.46', 'Page - Grid', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(161, 160, 95, 96, 3, 'com_content.article.47', 'Page - Slideshow 1', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(160, 8, 92, 107, 2, 'com_content.category.12', 'Pages', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(170, 64, 65, 66, 3, 'com_content.article.52', 'Unlimited Colors', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(162, 160, 97, 98, 3, 'com_content.article.48', 'Mosaic Gallery', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(166, 146, 89, 90, 3, 'com_content.article.50', 'Demo Article 9', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(163, 160, 99, 100, 3, 'com_content.article.49', 'Page - Prices', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(164, 18, 196, 197, 2, 'com_modules.module.199', 'Sample Price Tables', '{}'),
(165, 18, 198, 199, 2, 'com_modules.module.200', 'Sample Grid', ''),
(167, 18, 200, 201, 2, 'com_modules.module.201', 'Sample Mosaic Gallery Module', ''),
(168, 160, 101, 102, 3, 'com_content.article.51', 'Mosaic Portfolio', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(171, 64, 67, 68, 3, 'com_content.article.53', 'City -  Joomla Template', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(172, 18, 202, 203, 2, 'com_modules.module.203', 'Dot Nav Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(174, 18, 204, 205, 2, 'com_modules.module.205', 'Contact', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(175, 18, 206, 207, 2, 'com_modules.module.206', 'Testimonials', '{}'),
(176, 18, 208, 209, 2, 'com_modules.module.64', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(177, 18, 210, 211, 2, 'com_modules.module.63', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(178, 18, 212, 213, 2, 'com_modules.module.62', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(179, 18, 214, 215, 2, 'com_modules.module.22', 'Bottom A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(180, 18, 216, 217, 2, 'com_modules.module.21', 'Bottom A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(181, 18, 218, 219, 2, 'com_modules.module.20', 'Bottom A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(182, 18, 220, 221, 2, 'com_modules.module.28', 'Bottom B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(183, 18, 222, 223, 2, 'com_modules.module.27', 'Bottom B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(184, 18, 224, 225, 2, 'com_modules.module.17', 'Breadcrumbs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(185, 18, 226, 227, 2, 'com_modules.module.207', 'Home Top B Left', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(186, 18, 228, 229, 2, 'com_modules.module.208', 'Home Top B Right', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(192, 18, 230, 231, 2, 'com_modules.module.211', 'Sample Strips', '{}'),
(193, 18, 232, 233, 2, 'com_modules.module.212', 'Footer Right', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(194, 18, 234, 235, 2, 'com_modules.module.213', 'Toolbar Left', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(195, 18, 236, 237, 2, 'com_modules.module.214', 'Home Main Top', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(196, 18, 238, 239, 2, 'com_modules.module.215', 'Theme Features', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(197, 18, 240, 241, 2, 'com_modules.module.216', 'Toolbar Left', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(198, 18, 242, 243, 2, 'com_modules.module.217', 'Sample Strips', '{}'),
(199, 18, 244, 245, 2, 'com_modules.module.218', 'Home Bottom B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(200, 18, 246, 247, 2, 'com_modules.module.143', 'Bottom D', '{}'),
(201, 18, 248, 249, 2, 'com_modules.module.219', 'Recent From Blog', '{}'),
(202, 18, 250, 251, 2, 'com_modules.module.220', 'Features', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(203, 18, 252, 253, 2, 'com_modules.module.221', 'Socials', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(204, 18, 254, 255, 2, 'com_modules.module.222', 'Home Headerbar Slideshow (2)', '{}'),
(205, 160, 103, 104, 3, 'com_content.article.57', 'Sample Strips 1', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(206, 160, 105, 106, 3, 'com_content.article.58', 'Sample Strips 2', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(207, 64, 69, 70, 3, 'com_content.article.59', 'Center Menu & Logo', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(208, 1, 652, 653, 1, 'com_fields', 'com_fields', '{}'),
(209, 1, 654, 655, 1, 'com_associations', 'com_associations', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
`id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
`id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
`id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '1'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 23, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 519, '2009-10-18 16:07:09', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 519, '2010-06-28 13:26:37', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 519, '2010-06-28 13:27:35', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 519, '2010-06-28 13:27:57', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 519, '2010-06-28 13:28:15', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 9, 10, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 519, '2010-06-28 13:28:33', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 11, 12, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 519, '2011-05-02 11:42:21', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 56, 1, 13, 14, 1, 'contacts', 'com_contact', 'Contacts', 'contacts', '', '', 1, 42, '2012-01-23 15:30:29', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 519, '2011-11-18 16:32:10', 42, '2011-11-18 16:32:13', 0, '*', 1),
(9, 57, 1, 15, 16, 1, 'joomlaplates-links', 'com_weblinks', 'JoomlaPlates Links', 'joomlaplates-links', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 519, '2012-01-22 12:45:00', 667, '2013-06-23 19:14:03', 0, '*', 1),
(10, 64, 1, 17, 18, 1, 'template', 'com_content', 'template', 'template', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 519, '2013-06-21 21:20:54', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 146, 1, 19, 20, 1, 'sample-articles', 'com_content', 'Sample Articles', 'sample-articles', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 519, '2015-05-27 15:23:48', 0, '2015-05-27 15:23:48', 0, '*', 1),
(12, 160, 1, 21, 22, 1, 'pages', 'com_content', 'Pages', 'pages', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 519, '2015-06-08 19:25:17', 0, '2015-06-08 19:25:17', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
`id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'John Q. Public', 'john-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', 'email@0.0.0.0', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 8, 1, '', '', '', '', '', '*', '2011-11-18 16:33:47', 519, '', '2012-01-23 15:36:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(2, 'Jane Q. Public', 'jane-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', 'email@0.0.0.0', 0, 1, 0, '0000-00-00 00:00:00', 2, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 8, 1, '', '', '', '', '', '*', '2011-11-18 16:35:05', 519, '', '2012-01-19 16:37:23', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
`id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=60 ;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(1, 33, 'Module Variations', 'module-variations', '<p>This theme comes with different module styles, badges and icons. For each module you can pick a style and combine it with an icon or badge to create your own unique look. Here is a list of the available options:</p>\r\n\r\n<table class="uk-table uk-table-striped" width="100%" border="0">\r\n  <tr>\r\n    <td width="100px">Class:</td>\r\n    <td>uk-text-center, headline-border</td>\r\n  </tr>\r\n  <tr>\r\n    <td>Animation:</td>\r\n    <td>No, Fade, Scale Up, Scale Down, Slide Top/Bottom/Left/Right</td>\r\n  </tr>\r\n  <tr>\r\n    <td>Repeat:</td>\r\n    <td>On, Off</td>\r\n  </tr>\r\n  <tr>\r\n    <td>Style:</td>\r\n    <td>Default, Box, Box Primary/Secondary, Header, Space, Blank</td>\r\n  </tr>\r\n    <tr>\r\n    <td>Icon:</td>\r\n    <td>500 Icons (Font Awesome)</td>\r\n  </tr>\r\n  <tr>\r\n    <td>Badge:</td>\r\n    <td>Success, Warning, Danger</td>\r\n  </tr>\r\n  <tr>\r\n    <td>Display:</td>\r\n    <td>Desktop, Pad, Phone</td>\r\n  </tr>\r\n\r\n</table>\r\n<p><a data-uk-lightbox title="Module Parameter" href="images/joomlaplates/module-config.jpg"> <img class="shadow uk-margin-large-top" src="images/joomlaplates/module-config.jpg" border="0" alt="Demo Image" /> </a>\r\n</p>', '', 1, 10, '2011-05-02 11:45:23', 519, '', '2016-10-09 20:56:50', 519, 0, '0000-00-00 00:00:00', '2011-05-02 11:45:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 20, 5, '', '', 1, 2374, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(4, 36, 'UiKit', 'uikit', '		<div class="uk-grid">\r\n			<div class="uk-width-1-1" data-uk-margin>\r\n\r\n				<div class="uk-button-group">\r\n					<button class="uk-button">Button</button>\r\n					<div data-uk-dropdown="{mode:''click''}">\r\n						<button class="uk-button"><i class="uk-icon-caret-down"></i></button>\r\n						<div class="uk-dropdown uk-dropdown-width-2">\r\n\r\n							<div class="uk-grid">\r\n\r\n								<div class="uk-width-1-2">\r\n									<ul class="uk-nav uk-nav-dropdown uk-panel">\r\n										<li class="uk-nav-header">Header</li>\r\n										<li><a href="#">Item</a></li>\r\n										<li><a href="#">Item</a></li>\r\n										<li class="uk-nav-divider"></li>\r\n										<li><a href="#">Separated item</a></li>\r\n										<li class="uk-parent">\r\n											<a href="#">Parent</a>\r\n											<ul class="uk-nav-sub">\r\n												<li><a href="#">Sub item</a>\r\n													<ul>\r\n														<li><a href="#">Sub item</a></li>\r\n													</ul>\r\n												</li>\r\n											</ul>\r\n										</li>\r\n									</ul>\r\n								</div>\r\n\r\n								<div class="uk-width-1-2">\r\n									<ul class="uk-nav uk-nav-dropdown uk-panel">\r\n										<li class="uk-nav-header">Header</li>\r\n										<li><a href="#">Item</a></li>\r\n										<li><a href="#">Item</a></li>\r\n										<li class="uk-nav-divider"></li>\r\n										<li><a href="#">Separated item</a></li>\r\n										<li class="uk-parent">\r\n											<a href="#">Parent</a>\r\n											<ul class="uk-nav-sub">\r\n												<li><a href="#">Sub item</a>\r\n													<ul>\r\n														<li><a href="#">Sub item</a></li>\r\n													</ul>\r\n												</li>\r\n											</ul>\r\n										</li>\r\n									</ul>\r\n								</div>\r\n\r\n							</div>\r\n\r\n						</div>\r\n					</div>\r\n				</div>\r\n\r\n				<div class="uk-button-group">\r\n					<button class="uk-button uk-button-primary">Primary</button>\r\n					<div data-uk-dropdown="{mode:''click''}">\r\n						<button class="uk-button uk-button-primary"><i class="uk-icon-caret-down"></i></button>\r\n						<div class="uk-dropdown uk-dropdown-small">\r\n							<ul class="uk-nav uk-nav-dropdown">\r\n								<li class="uk-nav-header">Header</li>\r\n								<li><a href="#">Item</a></li>\r\n								<li><a href="#">Item</a></li>\r\n								<li class="uk-nav-divider"></li>\r\n								<li><a href="#">Separated item</a></li>\r\n								<li class="uk-parent">\r\n									<a href="#">Parent</a>\r\n									<ul class="uk-nav-sub">\r\n										<li><a href="#">Sub item</a>\r\n											<ul>\r\n												<li><a href="#">Sub item</a></li>\r\n											</ul>\r\n										</li>\r\n									</ul>\r\n								</li>\r\n							</ul>\r\n						</div>\r\n					</div>\r\n				</div>\r\n\r\n				<div class="uk-button-group">\r\n					<button class="uk-button uk-button-success">Success</button>\r\n					<div data-uk-dropdown="{mode:''click''}">\r\n						<button class="uk-button uk-button-success"><i class="uk-icon-caret-down"></i></button>\r\n						<div class="uk-dropdown">\r\n							<ul class="uk-nav uk-nav-dropdown">\r\n								<li class="uk-nav-header">Header</li>\r\n								<li><a href="#">Item</a></li>\r\n								<li><a href="#">Item</a></li>\r\n								<li class="uk-nav-divider"></li>\r\n								<li><a href="#">Separated item</a></li>\r\n								<li class="uk-parent">\r\n									<a href="#">Parent</a>\r\n									<ul class="uk-nav-sub">\r\n										<li><a href="#">Sub item</a>\r\n											<ul>\r\n												<li><a href="#">Sub item</a></li>\r\n											</ul>\r\n										</li>\r\n									</ul>\r\n								</li>\r\n							</ul>\r\n						</div>\r\n					</div>\r\n				</div>\r\n\r\n				<div class="uk-button-group">\r\n					<button class="uk-button uk-button-danger">Danger</button>\r\n					<div data-uk-dropdown="{mode:''click''}">\r\n						<button class="uk-button uk-button-danger"><i class="uk-icon-caret-down"></i></button>\r\n						<div class="uk-dropdown">\r\n							<ul class="uk-nav uk-nav-dropdown">\r\n								<li class="uk-nav-header">Header</li>\r\n								<li><a href="#">Item</a></li>\r\n								<li><a href="#">Item</a></li>\r\n								<li class="uk-nav-divider"></li>\r\n								<li><a href="#">Separated item</a></li>\r\n								<li class="uk-parent">\r\n									<a href="#">Parent</a>\r\n									<ul class="uk-nav-sub">\r\n										<li><a href="#">Sub item</a>\r\n											<ul>\r\n												<li><a href="#">Sub item</a></li>\r\n											</ul>\r\n										</li>\r\n									</ul>\r\n								</li>\r\n							</ul>\r\n						</div>\r\n					</div>\r\n				</div>\r\n\r\n				<button class="uk-button" disabled>Disabled</button>\r\n				<button class="uk-button" data-uk-tooltip title="Bazinga!">Tooltip</button>\r\n\r\n				<button class="uk-button" data-uk-modal="{target:''#modal-1''}">Modal</button>\r\n				<div id="modal-1" class="uk-modal">\r\n					<div class="uk-modal-dialog">\r\n						<button type="button" class="uk-modal-close uk-close"></button>\r\n						<h1>Headline</h1>\r\n						<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n					</div>\r\n				</div>\r\n\r\n				<button class="uk-button" data-uk-offcanvas="{target:''#offcanvas-3''}">Off-canvas</button>\r\n				<button class="uk-button-link">Button link</button>\r\n\r\n				<div id="offcanvas-3" class="uk-offcanvas">\r\n\r\n					<div class="uk-offcanvas-bar">\r\n\r\n						<ul class="uk-nav uk-nav-offcanvas uk-nav-parent-icon" data-uk-nav>\r\n							<li><a href="#">Item</a></li>\r\n							<li class="uk-active"><a href="#">Active</a></li>\r\n\r\n							<li class="uk-parent">\r\n								<a href="#">Parent</a>\r\n								<ul class="uk-nav-sub">\r\n									<li><a href="#">Sub item</a></li>\r\n									<li><a href="#">Sub item</a>\r\n										<ul>\r\n											<li><a href="#">Sub item</a></li>\r\n											<li><a href="#">Sub item</a></li>\r\n										</ul>\r\n									</li>\r\n								</ul>\r\n							</li>\r\n\r\n							<li class="uk-parent">\r\n								<a href="#">Parent</a>\r\n								<ul class="uk-nav-sub">\r\n									<li><a href="#">Sub item</a></li>\r\n									<li><a href="#">Sub item</a></li>\r\n								</ul>\r\n							</li>\r\n\r\n							<li><a href="#">Item</a></li>\r\n\r\n							<li class="uk-nav-header">Header</li>\r\n							<li><a href="#"><i class="uk-icon-star"></i> Item</a></li>\r\n							<li><a href="#"><i class="uk-icon-twitter"></i> Item</a></li>\r\n							<li class="uk-nav-divider"></li>\r\n							<li><a href="#"><i class="uk-icon-rss"></i> Item</a></li>\r\n						</ul>\r\n\r\n						<form class="uk-search">\r\n							<input class="uk-search-field" type="search" placeholder="search...">\r\n							<button class="uk-search-close" type="reset"></button>\r\n						</form>\r\n\r\n						<div class="uk-panel">\r\n							<h3 class="uk-panel-title">Title</h3>\r\n							Lorem ipsum dolor sit amet, <a href="#">consetetur</a> sadipscing elitr.\r\n						</div>\r\n\r\n						<div class="uk-panel">\r\n							<h3 class="uk-panel-title">Title</h3>\r\n							Lorem ipsum dolor sit amet, <a href="#">consetetur</a> sadipscing elitr.\r\n						</div>\r\n\r\n					</div>\r\n\r\n				</div>\r\n\r\n				<a href="#" class="uk-close"></a>\r\n				<a href="#" class="uk-close uk-close-alt"></a>\r\n\r\n			</div>\r\n		</div>\r\n\r\n		<hr class="uk-grid-divider">\r\n\r\n		<div class="uk-grid" data-uk-grid-margin>\r\n\r\n			<div class="uk-width-medium-1-2">\r\n\r\n				<div class="uk-grid" data-uk-grid-margin>\r\n\r\n					<div class="uk-width-1-1">\r\n						<ul class="uk-breadcrumb">\r\n							<li><a href="#">Home</a></li>\r\n							<li><a href="#">Blog</a></li>\r\n							<li><span>Category</span></li>\r\n							<li class="uk-active"><span>Post</span></li>\r\n						</ul>\r\n					</div>\r\n\r\n					<div class="uk-width-1-1">\r\n\r\n						<article class="uk-article">\r\n\r\n							<h1 class="uk-article-title">Article title</h1>\r\n\r\n							<p class="uk-article-meta">Written by Super User on 12 April. Posted in Blog</p>\r\n\r\n							<div class="uk-grid" data-uk-grid-margin>\r\n								<div class="uk-width-medium-1-2">\r\n									<a class="uk-thumbnail uk-overlay-toggle" href="#">\r\n										<div class="uk-overlay">\r\n											<img src="http://placekitten.com/300/90" alt="">\r\n											<div class="uk-overlay-area"></div>\r\n										</div>\r\n										<div class="uk-thumbnail-caption">Caption</div>\r\n									</a>\r\n								</div>\r\n\r\n								<div class="uk-width-medium-1-2">\r\n									<a class="uk-thumbnail uk-overlay-toggle" href="#">\r\n										<div class="uk-overlay">\r\n											<img src="http://placekitten.com/300/90" alt="">\r\n											<div class="uk-overlay-caption">Caption</div>\r\n										</div>\r\n									<div class="uk-thumbnail-caption">Caption</div>\r\n									</a>\r\n								</div>\r\n							</div>\r\n\r\n							<p class="uk-article-lead">Lorem ipsum dolor sit amet.</p>\r\n							<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n<pre><code>&lt;div class="myclass"&gt;...&lt;/div&gt;</code></pre>\r\n							<hr class="uk-article-divider">\r\n							<div class="uk-grid" data-uk-grid-margin>\r\n\r\n								<div class="uk-width-medium-1-5">\r\n									<span class="uk-text-muted">text-muted</span><br>\r\n									<span class="uk-text-info">text-info</span><br>\r\n									<span class="uk-text-success">text-success</span><br>\r\n									<span class="uk-text-warning">text-warning</span><br>\r\n									<span class="uk-text-danger">text-danger</span>\r\n								</div>\r\n\r\n								<div class="uk-width-medium-3-10">\r\n									<a href="#">a element</a><br>\r\n									<em>em element</em><br>\r\n									<strong>strong</strong><br>\r\n									<code>code element</code><br>\r\n									<del>del element</del>\r\n								</div>\r\n\r\n								<div class="uk-width-medium-2-5">\r\n									<ins>ins element</ins><br>\r\n									<mark>mark element</mark><br>\r\n									<q>q <q>inside</q> a q element </q><br>\r\n									<abbr title="Abbreviation Element">abbr element</abbr><br>\r\n									<dfn title="Defines a definition term">dfn element</dfn>\r\n								</div>\r\n\r\n								<div class="uk-width-1-1">\r\n									<p class="uk-text-center">\r\n										<span class="uk-badge">Badge</span>\r\n										<span class="uk-badge uk-badge-notification">1</span>\r\n										<span class="uk-badge uk-badge-success">Success</span>\r\n										<span class="uk-badge uk-badge-success uk-badge-notification">4</span>\r\n										<span class="uk-badge uk-badge-warning">Warning</span>\r\n										<span class="uk-badge uk-badge-warning uk-badge-notification">3</span>\r\n										<span class="uk-badge uk-badge-danger">Danger</span>\r\n										<span class="uk-badge uk-badge-danger uk-badge-notification">4</span>\r\n									</p>\r\n								</div>\r\n\r\n								<div class="uk-width-medium-1-2">\r\n									<h1 class="uk-display-inline">h1</h1>\r\n									<h2 class="uk-display-inline">h2</h2>\r\n									<h3 class="uk-display-inline">h3</h3>\r\n									<h4 class="uk-display-inline">h4</h4>\r\n									<h5 class="uk-display-inline">h5</h5>\r\n									<h6 class="uk-display-inline">h6</h6>\r\n								</div>\r\n\r\n								<div class="uk-width-medium-1-2">\r\n									<blockquote>\r\n										<p> Lorem ipsum dolor.</p>\r\n										<small>Someone famous</small>\r\n									</blockquote>\r\n								</div>\r\n\r\n							</div>\r\n\r\n						</article>\r\n\r\n					</div>\r\n\r\n					<div class="uk-width-1-1">\r\n						<ul class="uk-comment-list">\r\n							<li>\r\n								<article class="uk-comment">\r\n									<header class="uk-comment-header">\r\n										<img class="uk-comment-avatar" src="http://placekitten.com/50/50" alt="">\r\n										<h4 class="uk-comment-title">Author</h4>\r\n										<p class="uk-comment-meta">May 2, 2090 at 1:55 pm</p>\r\n									</header>\r\n									<div class="uk-comment-body">\r\n										<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna.</p>\r\n									</div>\r\n								</article>\r\n							</li>\r\n						</ul>\r\n					</div>\r\n\r\n					<div class="uk-width-1-1">\r\n						<ul class="uk-pagination">\r\n							<li class="uk-disabled"><span><i class="uk-icon-angle-double-left"></i></span></li>\r\n							<li class="uk-active"><span>1</span></li>\r\n							<li><a href="#">2</a></li>\r\n							<li><a href="#">3</a></li>\r\n							<li><a href="#">4</a></li>\r\n							<li><span>...</span></li>\r\n							<li><a href="#">20</a></li>\r\n							<li><a href="#"><i class="uk-icon-angle-double-right"></i></a></li>\r\n						</ul>\r\n					</div>\r\n\r\n				</div>\r\n\r\n			</div>\r\n\r\n			<div class="uk-width-medium-1-2">\r\n\r\n				<div class="uk-grid" data-uk-grid-margin>\r\n\r\n					<div class="uk-width-medium-1-2">\r\n\r\n						<div class="uk-panel">\r\n							<ul class="uk-nav uk-nav-side uk-nav-parent-icon" data-uk-nav>\r\n								<li class="uk-nav-header">Header</li>\r\n								<li class="uk-nav-divider"></li>\r\n								<li class="uk-active"><a href="#">Active</a></li>\r\n								<li class="uk-parent">\r\n									<a href="#">Parent</a>\r\n									<ul class="uk-nav-sub">\r\n										<li><a href="#">Sub item</a></li>\r\n										<li><a href="#">Sub item</a>\r\n											<ul>\r\n												<li><a href="#">Sub item</a></li>\r\n												<li><a href="#">Sub item</a></li>\r\n											</ul>\r\n										</li>\r\n									</ul>\r\n								</li>\r\n								<li><a href="#">Item</a></li>\r\n							</ul>\r\n						</div>\r\n\r\n						<div class="uk-panel uk-panel-divider">\r\n							<h3 class="uk-panel-title">Divider</h3>\r\n							Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\r\n						</div>\r\n\r\n						<div class="uk-panel uk-panel-header">\r\n							<h3 class="uk-panel-title">Header</h3>\r\n							Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\r\n						</div>\r\n\r\n					</div>\r\n\r\n					<div class="uk-width-medium-1-2">\r\n\r\n						<div class="uk-panel">\r\n							<h3 class="uk-panel-title">Box</h3>\r\n							Lorem ipsum dolor sit amet, consectetur adipisicing elit.\r\n						</div>\r\n\r\n						<div class="uk-panel uk-panel-box uk-panel-box-primary">\r\n							<h3 class="uk-panel-title">Box primary</h3>\r\n							Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\r\n						</div>\r\n\r\n						<div class="uk-panel uk-panel-box uk-panel-box-secondary">\r\n							<h3 class="uk-panel-title">Box secondary</h3>\r\n							Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\r\n						</div>\r\n\r\n					</div>\r\n\r\n				</div>\r\n\r\n				<div class="uk-grid" data-uk-grid-margin>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-alert" data-uk-alert>\r\n							<a class="uk-alert-close uk-close"></a>\r\n							<p>Info message</p>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-alert uk-alert-success" data-uk-alert>\r\n							<a class="uk-alert-close uk-close"></a>\r\n							<p>Success message</p>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-alert uk-alert-warning" data-uk-alert>\r\n							<a class="uk-alert-close uk-close"></a>\r\n							<p>Warning message</p>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-alert uk-alert-danger" data-uk-alert>\r\n							<a class="uk-alert-close uk-close"></a>\r\n							<p>Danger message</p>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-progress">\r\n							<div class="uk-progress-bar" style="width: 55%;">55%</div>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-progress uk-progress-success">\r\n							<div class="uk-progress-bar" style="width: 55%;">55%</div>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-progress uk-progress-warning">\r\n							<div class="uk-progress-bar" style="width: 55%;">55%</div>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<div class="uk-progress uk-progress-danger">\r\n							<div class="uk-progress-bar" style="width: 55%;">55%</div>\r\n						</div>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<fieldset class="uk-form">\r\n							<legend>Form states</legend>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="Text Input" class="uk-width-1-1">\r\n							</div>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="form-success" value="form-success" class="uk-width-1-1 uk-form-success">\r\n							</div>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="form-danger" value="form-danger" class="uk-width-1-1 uk-form-danger">\r\n							</div>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="form disabled" class="uk-width-1-1" disabled>\r\n							</div>\r\n						</fieldset>\r\n					</div>\r\n\r\n					<div class="uk-width-1-2">\r\n						<fieldset class="uk-form">\r\n							<legend>Form styles</legend>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="form-large" class="uk-form-large uk-form-width-small">\r\n								<button class="uk-button uk-button-large" type="reset">Large</button>\r\n							</div>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="form-small" class="uk-form-small uk-form-width-small">\r\n								<button class="uk-button uk-button-small" type="reset">Small</button>\r\n							</div>\r\n							<div class="uk-form-row">\r\n								<input type="text" placeholder="form-blank" class="uk-form-width-small uk-form-blank">\r\n								<button class="uk-button uk-button-mini" type="reset">Mini</button>\r\n							</div>\r\n						</fieldset>\r\n					</div>\r\n\r\n				</div>\r\n\r\n			</div>\r\n\r\n		</div>\r\n\r\n		<hr class="uk-grid-divider">\r\n\r\n		<div class="uk-grid" data-uk-grid-margin>\r\n\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<ul class="uk-subnav uk-subnav-line">\r\n					<li class="uk-active"><a href="#">Active</a></li>\r\n					<li><a href="#">Item</a></li>\r\n					<li><span>Disabled</span></li>\r\n				</ul>\r\n\r\n			</div>\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<ul class="uk-subnav uk-subnav-pill">\r\n					<li class="uk-active"><a href="#">Active</a></li>\r\n					<li><a href="#">Item</a></li>\r\n					<li><span>Disabled</span></li>\r\n				</ul>\r\n\r\n			</div>\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<ul class="uk-tab" data-uk-tab>\r\n					<li class="uk-active"><a href="#">Active</a></li>\r\n					<li><a href="#">Item</a></li>\r\n					<li class="uk-disabled"><a href="#">Disabled</a></li>\r\n				</ul>\r\n\r\n			</div>\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<a href="#" class="uk-icon-button uk-icon-github"></a>\r\n				<a href="#" class="uk-icon-button uk-icon-twitter"></a>\r\n				<a href="#" class="uk-icon-button uk-icon-dribbble"></a>\r\n				<a href="#" class="uk-icon-button uk-icon-html5"></a>\r\n\r\n			</div>\r\n		</div>\r\n\r\n		<hr class="uk-grid-divider">\r\n\r\n		<div class="uk-grid uk-grid-divider" data-uk-grid-margin>\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<ul class="uk-list uk-list-line">\r\n					<li>List item 1</li>\r\n					<li>List item 2</li>\r\n					<li>List item 3</li>\r\n				</ul>\r\n\r\n			</div>\r\n\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<ul class="uk-list uk-list-striped">\r\n					<li>List item 1</li>\r\n					<li>List item 2</li>\r\n					<li>List item 3</li>\r\n				</ul>\r\n\r\n			</div>\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<table class="uk-table uk-table-striped uk-table-condensed uk-table-hover">\r\n					<caption>Table caption</caption>\r\n					<thead>\r\n						<tr>\r\n							<th>Table</th>\r\n							<th>Heading</th>\r\n						</tr>\r\n					</thead>\r\n					<tbody>\r\n						<tr>\r\n							<td>Table</td>\r\n							<td>Data</td>\r\n						</tr>\r\n						<tr>\r\n							<td>Table</td>\r\n							<td>Data</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n\r\n			</div>\r\n			<div class="uk-width-medium-1-4">\r\n\r\n				<dl class="uk-description-list uk-description-list-line">\r\n					<dt>Description lists</dt>\r\n					<dd>Description text.</dd>\r\n					<dt>Description lists</dt>\r\n					<dd>Description text.</dd>\r\n				</dl>\r\n\r\n			</div>\r\n		</div>\r\n		<hr class="uk-grid-divider">\r\n		<h3 class="uk-text-center"><a class="uk-button uk-button-default uk-text-center" target="_blank" href="http://getuikit.com/docs/core.html">All UIkit Typo, Core & Compontents</a>	\r\n		</h3>\r\n	\r\n		', '', 1, 10, '2011-05-02 11:47:45', 519, '', '2015-05-27 21:37:06', 714, 0, '0000-00-00 00:00:00', '2011-05-02 11:47:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 24, 6, '', '', 1, 984, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(45, 154, 'Demo Article 8', 'demo-article-8', '<img src="images/joomlaplates/demo-008.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-05-27 15:27:17', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(5, 37, 'Dummy Content', 'dummy-content', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '', 1, 10, '2011-05-02 11:48:08', 519, '', '2015-05-27 21:09:56', 714, 0, '0000-00-00 00:00:00', '2011-05-02 11:48:08', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 2, 7, '', '', 1, 869, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(6, 38, 'Features', 'features', '<p class="article-lead">The general theme section allows you to control the behaviour and the overall appearance of your theme.</p>\r\n<h2>Style</h2>\r\n<p>The style section contains the customizer. Hit the <em>Customizer</em> button to add your own style or to modify an existing style. After the customizer is loaded, you can easily customize colors, fonts, margins and even more settings of the theme. The customizer saves only the modified variables and automatically compiles them into CSS.</p>\r\n<br>\r\n<p> </p>\r\n<h2>Screenshots</h2>\r\n<p><a data-lightbox="on" href="images/joomlaplates/config-001.jpg"> <img class="screenshots" src="images/joomlaplates/config-001.jpg" border="0" alt="Demo Image" width="140px" /> </a> <a data-lightbox="on" href="images/joomlaplates/config-002.jpg"> <img class="screenshots" src="images/joomlaplates/config-002.jpg" border="0" alt="Demo Image" width="140px" /> </a> <a data-lightbox="on" href="images/joomlaplates/config-003.jpg"> <img class="screenshots" src="images/joomlaplates/config-003.jpg" border="0" alt="Demo Image" width="140px" /> </a> <a data-lightbox="on" href="images/joomlaplates/config-004.jpg"> <img class="screenshots" src="images/joomlaplates/config-004.jpg" border="0" alt="Demo Image" width="140px" /> </a></p>', '', -2, 10, '2011-05-02 11:48:41', 519, '', '2015-05-27 21:09:56', 714, 0, '0000-00-00 00:00:00', '2011-05-02 11:48:41', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 24, 9, '', '', 1, 1624, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(7, 39, 'Sticky Menu = Off', 'sticky-menu-off', '<p>Our new "City" <strong>Joomla Template</strong> is dedicated for travel companies or any other clean business site. The theme is a sleek and modern Joomla design that does a great job displaying tons of content while at the same time avoiding the feeling of clutter. Powerful design elements and a strict grid give the theme an organized layout that is a pleasure to read. This template is also fully responsive, meaning that the design will adapt to mobile phones and tablets for a more intuitive browsing experience. \r\n</p>\r\n<p>Packaged with the Warp 7 Framework template system delivering complete control over the template styles, from Width Adjustments, Region and Column Layout, Backgrounds, Font Colors / Sizes / Typeset, Module Layout, and many custom styles.</p>\r\n<p>Template control has never been easier!</p>\r\n    <a href="images/joomlaplates/city.jpg" data-uk-lightbox title="City Template"><img class="uk-text-center" src="images/joomlaplates/city.jpg" alt="City Joomla Template" border="0" /></a>\r\n</p>', '', 1, 10, '2011-05-02 11:49:24', 519, '', '2017-01-29 23:27:43', 519, 0, '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"0","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 140, 8, '', '', 1, 66309, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(57, 205, 'Sample Strips 1', 'sample-strips-1', '[module-211]', '', 1, 12, '2017-02-05 19:27:08', 519, '', '2017-02-05 19:27:08', 0, 0, '0000-00-00 00:00:00', '2017-02-05 19:27:08', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 1, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(8, 40, 'Sample Blog Article', 'sample-blog-article-1', '<p><img title="Theme Framework" src="images/joomlaplates/demo-002.jpg" alt="Warp Theme Framework" border="0" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 1, 7, '2012-04-04 11:50:00', 519, '', '2016-05-19 22:11:30', 519, 0, '0000-00-00 00:00:00', '2015-06-23 11:50:00', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 48, 1, '', '', 1, 226, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '', ''),
(10, 42, 'Sample Blog Article', 'sample-blog-3-column-sidebar', '<p><img title="Theme Framework" src="images/joomlaplates/demo-002.jpg" alt="Warp Theme Framework" border="0" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 1, 7, '2012-03-20 11:50:55', 519, '', '2015-05-27 21:15:46', 714, 0, '0000-00-00 00:00:00', '2012-03-20 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 2, '', '', 1, 120, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '', ''),
(23, 66, 'Sample Blog Article', 'sample-blog-2', '<p><img title="Theme Framework" src="images/joomlaplates/demo-003.jpg" alt="Warp Theme Framework" border="0" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 1, 7, '2012-03-13 11:50:55', 519, '', '2015-05-27 21:15:37', 714, 0, '0000-00-00 00:00:00', '2012-03-13 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 3, '', '', 1, 109, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '', ''),
(24, 65, 'Module Positions', 'module-positions', '<h2>Module Layout</h2>\r\n<p><img class="size-auto" style="margin: 0 20px 20px 0;" src="images/joomlaplates/features_module_layouts.png" alt="module-layout" align="left" border="0" /></p>\r\n<p>This theme comes with a lot of module positions. The <strong>blue</strong> module positions allow to choose a module layout which defines the module alignment and proportions:</p>\r\n<p><em>parallel, first-doubled, last-doubled or stacked.</em></p>\r\n<p class="clearfix"></p>\r\n<h2>Column Layout</h2>\r\n<p><img class="size-auto" style="margin: 0 20px 20px 0;" src="images/joomlaplates/features_column_layouts.png" alt="module-layout" align="left" border="0" /></p>\r\n<p>The two available sidebars, highlighted in<strong> red</strong>, can be switched to the left or right side and their widths can easily be set in the theme administration.</p>\r\n<p>For modules in the<strong> blue and red</strong> positions you can choose different module styles. Take a look at the module variations page to get an overview.</p>\r\n<p class="clearfix"></p>\r\n<h2>Module Positions</h2>\r\n<p><img class="size-auto" src="images/joomlaplates/module_positions.jpg" alt="module-layout" align="left" border="0" /></p>', '', 1, 10, '2013-06-21 21:21:23', 519, '', '2016-05-19 22:04:39', 519, 0, '0000-00-00 00:00:00', '2013-06-21 21:21:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 23, 4, '', '', 1, 1560, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(30, 74, 'Customizer Included', 'customizer-included', '<p>Pick colors, select fonts and modify sizes without any CSS coding. See the changes in a real-time preview.</p>\r\n<em>Just a short example how to customize the headerbar background</em>\r\n<div class="responsive-video">\r\n<iframe width="560" height="315" src="https://www.youtube.com/embed/TGhPoR1X5ws" frameborder="0" allowfullscreen></iframe>\r\n</div>\r\n\r\n\r\n\r\n', '', 1, 10, '2014-03-26 01:12:56', 519, '', '2017-02-10 23:28:02', 519, 0, '0000-00-00 00:00:00', '2014-03-26 01:12:56', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 52, 2, '', '', 1, 103, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(31, 76, '1st Class Joomla Template - Game Style', '1st-class-joomla-template-game-style', '<p>This Joomla Template is based on Warp7* Framework and made for all who wants a lightweight and modular website. The warm and modern design is perfect to create a website for your business. </p>\r\n<p>At the top of the page you can insert a big logo and a slideshow or a static image.</p>\r\n<p>And all 48 module positions are collapsible and have different styles which can be selected from Joomla Template control panel.</p>\r\n<p>If your looking for the <strong>1st class</strong> Joomla template,   which you can easily customize, take a look at this Joomla Template.</p>\r\n\r\n<p><a data-lightbox="on" href="images/joomlaplates/1stclass.jpg"><img style="margin:20px 0 0" src="images/joomlaplates/1stclass.jpg" border="0" alt="Ultimate" /></a></p>\r\n<hr class="style-two">\r\n<h1 style="font-size:40px; text-align:center"><span>Template Features</span></h1>\r\n<h5 style="font-size:24px; text-align:center">Clean - Flexible - Powerfull - Responsive</h5>\r\n<br>\r\n<div style="width: 50%; float: left;">\r\n<ul class="plus">\r\n<li>Joomla 3.x and Joomla 2.5 compatible</li>\r\n<li>46 Collapsible Module positions</li>\r\n<li>Unlimited Theme Colors</li>\r\n<li>Based on Warp7* Framework</li>\r\n<li>Unlimted Background Colors</li>\r\n<li>Powerful & Responsive Slideshow included</li>\r\n<li>Simple Lightbox without Javascript Conflict</li>\r\n</ul>\r\n</div>\r\n<div style="width: 50%; float: right;">\r\n<ul class="plus">\r\n<li>Top Slider ot static Image</li>\r\n<li>Real Time Customizer from Backend</li>\r\n<li>300 Google Fonts included</li>\r\n<li>8 Module Style combinable with 4 Badges and 6 Icons</li>\r\n<li>Megamenu with Icons and Subtitles</li>\r\n<li>Great YooTheme <a target="_blank" href="http://getuikit.com/">UiKit</a> included</li>\r\n<li>Quickstart Package Included</li>\r\n</ul>\r\n</div>\r\n', '', -2, 2, '2011-05-02 11:49:24', 519, '', '2014-11-12 14:43:25', 667, 0, '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"0","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 109, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(32, 77, 'Smooth Scroll to any Section', 'smooth-scroll-to-any-section', '<p>Create a cool "one page" layout! We have included a "smooth-scroll" function where you can scroll from menu item to any "section" where your modules are stored.\r\n<p>Sections: <em>top-a, top-b, top-c, top-d, main-content, bottom-a, bottom-b, bottom-c, footer-a</em></p>\r\n<p>Example: Scroll to <a class="scroll" href="#bottom-c">bottom-c</a></p>\r\n\r\n<img border="0" alt="Scroll" src="images/joomlaplates/scroll.jpg" class="size-auto shadow uk-margin-large-bottom uk-margin-large-top">\r\n<hr />\r\n<h1 class="uk-article-title">Dot-Nav Menu with Scroll Function</h1>\r\nTo create a navigation with dots, just add the text shown below to the module positions "absolute". This feature is built with Dot-Nav and <a href="http://getuikit.com/docs/dotnav.html">uikit</a>. \r\n<p>Sections: <em>top-a, top-b, top-c, top-d, main-content, bottom-a, bottom-b, bottom-c, footer-a</em></p>\r\n\r\n<a href="images/joomlaplates/dot-nav.jpg" data-uk-lightbox title="Dot Nav"><img border="0" alt="Scroll" src="images/joomlaplates/dot-nav.jpg" class="size-auto shadow uk-margin-large-bottom uk-margin-large-top"></a>', '', 1, 10, '2011-05-02 11:49:24', 519, '', '2015-07-13 21:35:00', 845, 0, '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"0","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 128, 9, '', '', 1, 97, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(33, 78, 'Sidebar Right', 'sidebar-right', '<p>Our new "City" <strong>Joomla Template</strong> is dedicated for travel companies or any other clean business site. The theme is a sleek and modern Joomla design that does a great job displaying tons of content while at the same time avoiding the feeling of clutter. Powerful design elements and a strict grid give the theme an organized layout that is a pleasure to read. This template is also fully responsive, meaning that the design will adapt to mobile phones and tablets for a more intuitive browsing experience. \r\n</p>\r\n<p>Packaged with the Warp 7 Framework template system delivering complete control over the template styles, from Width Adjustments, Region and Column Layout, Backgrounds, Font Colors / Sizes / Typeset, Module Layout, and many custom styles.</p>\r\n<p>Template control has never been easier!</p>\r\n    <a href="images/joomlaplates/city.jpg" data-uk-lightbox title="City Template"><img class="uk-text-center" src="images/joomlaplates/city.jpg" alt="City Joomla Template" border="0" /></a>\r\n</p>', '', 1, 10, '2011-05-02 11:49:24', 519, '', '2017-01-29 23:27:30', 519, 0, '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"0","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 122, 10, '', '', 1, 39, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(34, 79, 'Sidebar Left', 'sidebar-left', '<p>Our new "City" <strong>Joomla Template</strong> is dedicated for travel companies or any other clean business site. The theme is a sleek and modern Joomla design that does a great job displaying tons of content while at the same time avoiding the feeling of clutter. Powerful design elements and a strict grid give the theme an organized layout that is a pleasure to read. This template is also fully responsive, meaning that the design will adapt to mobile phones and tablets for a more intuitive browsing experience. \r\n</p>\r\n<p>Packaged with the Warp 7 Framework template system delivering complete control over the template styles, from Width Adjustments, Region and Column Layout, Backgrounds, Font Colors / Sizes / Typeset, Module Layout, and many custom styles.</p>\r\n<p>Template control has never been easier!</p>\r\n    <a href="images/joomlaplates/city.jpg" data-uk-lightbox title="City Template"><img class="uk-text-center" src="images/joomlaplates/city.jpg" alt="City Joomla Template" border="0" /></a>\r\n</p>', '', 1, 10, '2011-05-02 11:49:24', 519, '', '2017-01-29 23:27:20', 519, 0, '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"0","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 125, 11, '', '', 1, 92, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(53, 171, 'City -  Joomla Template', 'city-joomla-template', '<p>Our new "City"  <strong>Joomla Template</strong> is dedicated for travel companies or any other clean business site. The theme is a sleek and modern Joomla design that does a great job displaying tons of content while at the same time avoiding the feeling of clutter. Powerful design elements and a strict grid give the theme an organized layout that is a pleasure to read. This template is also fully responsive, meaning that the design will adapt to mobile phones and tablets for a more intuitive browsing experience.</p>\r\n<p>Packaged with the Warp 7 Framework template system delivering complete control over the template styles, from Width Adjustments, Region and Column Layout, Backgrounds, Font Colors / Sizes / Typeset, Module Layout, and many custom styles.</p>\r\n<p>Template control has never been easier!</p>\r\n<p><a href="images/joomlaplates/city.jpg" data-uk-lightbox="" title="City Template"><img class="uk-text-center" src="images/joomlaplates/city.jpg" alt="City Joomla Template" border="0" /></a></p>', '', 1, 10, '2015-06-08 21:34:49', 519, '', '2017-03-28 15:14:14', 519, 0, '0000-00-00 00:00:00', '2015-06-08 21:34:49', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 49, 3, '', '', 1, 1907, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(35, 80, 'Sample Blog Article', 'sample-blog-3', '<p><img title="Theme Framework" src="images/joomlaplates/demo-004.jpg" alt="Warp Theme Framework" border="0" /></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>', 1, 7, '2014-11-18 02:44:05', 519, '', '2015-06-24 10:52:22', 845, 0, '0000-00-00 00:00:00', '2015-06-24 02:44:00', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, '', '', 1, 9, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(38, 147, 'Demo Article 1', 'demo-article-1', '<img src="images/joomlaplates/demo-001.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-06-08 22:25:12', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(39, 148, 'Demo Article 2', 'demo-article-2', '<img src="images/joomlaplates/demo-002.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-05-27 15:25:59', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(40, 149, 'Demo Article 3', 'demo-article-3', '<img src="images/joomlaplates/demo-003.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-05-27 15:26:15', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(41, 150, 'Demo Article 4', 'demo-article-4', '<img src="images/joomlaplates/demo-004.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-06-08 22:44:18', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(42, 151, 'Demo Article 5', 'demo-article-5', '<img src="images/joomlaplates/demo-005.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-05-27 15:26:42', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(43, 152, 'Demo Article 6', 'demo-article-6', '<img src="images/joomlaplates/demo-006.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-05-27 15:26:54', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(44, 153, 'Demo Article 7', 'demo-article-7', '<img src="images/joomlaplates/demo-007.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-05-27 15:27:06', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(46, 159, 'Page - Grid', 'pages-grid', '[module-200]', '', 1, 12, '2015-06-08 19:24:56', 519, '', '2015-06-08 22:15:34', 714, 0, '0000-00-00 00:00:00', '2015-06-08 19:24:56', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 6, '', '', 1, 96, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(47, 161, 'Page - Slideshow 1', 'page-slideshow-1', '<hr class="style-one" style="margin-top:50px" />\r\n<div class="uk-grid uk-margin-large-top">\r\n    \r\n    <div class="uk-width-medium-1-2">\r\n        <p>\r\n            <a href="images/joomlaplates/bike.jpg" data-uk-lightbox title="Demo Image"><img src="images/joomlaplates/bike.jpg" alt="bike" border="0" /></a>\r\n        </p>\r\n    </div>\r\n    \r\n    <div class="uk-width-medium-1-2">\r\n        <h3 class="uk-panel-title">INSPIRE! <span style="font-weight:100">JOOMLA TEMPLATE</span></h3>\r\n        <h4 class="text-color">Clean - Flexible - Powerfull - Responsive</h4>\r\n        <p>INSPIRE! is a beautiful minimalist template for Joomla. Light weight and feature packed, it refines the flat design trend and comes enhanced with Joomla overrides and custom styling with all <a href="http://getuikit.com/index.html"><u>uikit</u></a> features.</p> <p>INSPIRE! features four different color styles fully customizable to handle just about any web project and content.\r\n       </p>\r\n    </div>\r\n</div>', '', 1, 12, '2015-06-08 21:34:49', 519, '', '2015-06-08 23:17:50', 714, 0, '0000-00-00 00:00:00', '2015-06-08 21:34:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"0","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 5, '', '', 1, 20, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(48, 162, 'Mosaic Gallery', 'mosaic-gallery', '[module-198]\r\n', '', 1, 12, '2015-06-08 21:34:49', 519, '', '2015-06-08 23:04:53', 714, 0, '0000-00-00 00:00:00', '2015-06-08 21:34:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 3, '', '', 1, 33, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(49, 163, 'Page - Prices', 'page-prices', '[module-199]', '', 1, 12, '2015-06-08 21:34:49', 519, '', '2015-06-08 21:45:58', 714, 0, '0000-00-00 00:00:00', '2015-06-08 21:34:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 2, '', '', 1, 64, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(50, 166, 'Demo Article 9', 'demo-article-9', '<img src="images/joomlaplates/demo-003.jpg" alt="Demo Image" />\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p> <p>Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. </p>', '', 1, 11, '2015-05-27 15:25:16', 519, '', '2015-06-08 22:25:42', 714, 0, '0000-00-00 00:00:00', '2015-05-27 15:25:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(51, 168, 'Mosaic Portfolio', 'mosaic-portfolio', '[module-201]', '', 1, 12, '2015-06-08 21:34:49', 519, '', '2015-07-13 19:24:48', 845, 0, '0000-00-00 00:00:00', '2015-06-08 21:34:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 4, '', '', 1, 50, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(52, 170, 'Unlimited Colors', 'unlimited-colors', '<p>Unlimited Site, Menu, Logobar and Section Colors. The background color configuration can be done with the built in real-time customizer from Joomla Template Backend.</p>\r\n\r\n<p><strong>Site Backgrounds:</strong> Unlimited Color Options</p>\r\n<p><strong>Logobar Backgrounds:</strong> Unlimited Color Options</p>\r\n<p><strong>Menu Backgrounds:</strong> Unlimited Color Options</p>\r\n<p><strong>Section Backgrounds:</strong> Unlimited Color Options</p>\r\n<div class="responsive-video">\r\n<iframe width="560" height="315" src="https://www.youtube.com/embed/TGhPoR1X5ws" frameborder="0" allowfullscreen></iframe>	\r\n</div>', '', 1, 10, '2015-06-09 01:43:35', 519, '', '2017-02-07 22:37:56', 519, 0, '0000-00-00 00:00:00', '2015-06-09 01:43:35', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 16, 1, '', '', 1, 40, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(58, 206, 'Sample Strips 2', 'sample-strips-2', '[module-217]', '', 1, 12, '2017-02-05 19:29:46', 519, '', '2017-02-05 19:29:46', 0, 0, '0000-00-00 00:00:00', '2017-02-05 19:29:46', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(59, 207, 'Center Menu & Logo', 'center-menu-logo', '<p>Our new "City" <strong>Joomla Template</strong> is dedicated for travel companies or any other clean business site. The theme is a sleek and modern Joomla design that does a great job displaying tons of content while at the same time avoiding the feeling of clutter. Powerful design elements and a strict grid give the theme an organized layout that is a pleasure to read. This template is also fully responsive, meaning that the design will adapt to mobile phones and tablets for a more intuitive browsing experience. \r\n</p>\r\n<p>Packaged with the Warp 7 Framework template system delivering complete control over the template styles, from Width Adjustments, Region and Column Layout, Backgrounds, Font Colors / Sizes / Typeset, Module Layout, and many custom styles.</p>\r\n<p>Template control has never been easier!</p>\r\n    <a href="images/joomlaplates/city.jpg" data-uk-lightbox title="City Template"><img class="uk-text-center" src="images/joomlaplates/city.jpg" alt="City Joomla Template" border="0" /></a>\r\n</p>', '', 1, 10, '2015-06-08 21:34:49', 519, '', '2017-02-05 22:21:33', 519, 0, '0000-00-00 00:00:00', '2015-06-08 21:34:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 9, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', '');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(8, 6),
(9, 5),
(10, 4),
(11, 3),
(12, 2),
(23, 1);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
`type_id` int(10) unsigned NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10005 ;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}, "special": {"fulltext":"fulltext"}}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"url", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {}}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special": {}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(10000, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(10001, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10002, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(10003, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(10004, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
`extension_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10092 ;

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":"","filename":"mailto"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":"","filename":"wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":"","filename":"banners"}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{"contact_layout":"_:default","show_contact_category":"hide","show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"0","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_items":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","show_pagination_limit":"1","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_pagination":"2","show_pagination_results":"1","initial_sort":"ordering","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '{"show_jed_info":"0","cachetimeout":"6"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0","show_headings":"1","show_name":"1","show_articles":"0","show_link":"1","show_description":"1","show_description_image":"1","display_num":"","show_pagination_limit":"1","show_pagination":"1","show_pagination_results":"1","show_cat_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":"","filename":"search"}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"1","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 0, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_weblinks","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":""}', '{"target":"0","count_clicks":"1","icons":1,"link_icons":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_num_links":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_links_cat":"1","show_pagination_limit":"1","show_headings":"1","show_link_description":"1","show_link_hits":"1","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","info_block_position":"0","show_category":"0","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_author":"1","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"1","show_vote":"0","show_readmore":"1","show_readmore_title":"1","readmore_limit":"100","show_tags":"1","show_icons":"1","show_print_icon":"0","show_email_icon":"0","show_hits":"1","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","save_history":"0","history_limit":10,"show_urls_images_frontend":"1","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"right","float_fulltext":"right","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"9":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"2":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":"","filename":"users"}', '{"allowUserRegistration":"0","new_usertype":"2","guest_usergroup":"1","sendpassword":"1","useractivation":"1","mail_to_admin":"0","captcha":"","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"0","show_autosuggest":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","sort_order":"relevance","sort_direction":"desc","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stem":"1","stemmer":"porter_en"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.2","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":"","filename":"contenthistory"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":"","filename":"ajax"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{"name":"plg_installer_packageinstaller","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"packageinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{"name":"PLG_INSTALLER_FOLDERINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"folderinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{"name":"PLG_INSTALLER_URLINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"urlinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"LIB_PHPUTF8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":"","filename":"phputf8"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"LIB_JOOMLA","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"https:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"mediaversion":"f2babb5e9e66ceb0cf851181b864d2b3"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{"name":"LIB_IDNA","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":"","filename":"idna_convert"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2015-04-22 13:15:32","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2015 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.4.3","description":"LIB_FOF_XML_DESCRIPTION","group":"","filename":"fof"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{"name":"LIB_PHPASS","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":"","filename":"phpass"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":"","filename":"mod_articles_archive"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_articles_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":"","filename":"mod_banners"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":"","filename":"mod_breadcrumbs"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":"","filename":"mod_footer"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_news"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":"","filename":"mod_random_image"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":"","filename":"mod_related_items"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":"","filename":"mod_search"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":"","filename":"mod_syndicate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":"","filename":"mod_users_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 0, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":"","filename":"mod_whosonline"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":"","filename":"mod_wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":"","filename":"mod_articles_category"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":"","filename":"mod_articles_categories"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":"","filename":"mod_languages"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":"","filename":"mod_finder"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":"","filename":"mod_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":"","filename":"mod_logged"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":"","filename":"mod_quickicon"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":"","filename":"mod_status"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":"","filename":"mod_submenu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":"","filename":"mod_title"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":"","filename":"mod_toolbar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":"","filename":"mod_multilangstatus"}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":"","filename":"mod_version"}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats_admin"}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_tags_popular"}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":"","filename":"mod_tags_similar"}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":"","filename":"gmail"}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":"","filename":"ldap"}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":"","filename":"emailcloak"}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 0, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, '{"legacy":false,"name":"plg_content_geshi","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"","authorUrl":"qbnz.com\\/highlighter","version":"2.5.0","description":"PLG_CONTENT_GESHI_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":"","filename":"loadmodule"}', '{"style":"none"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":"","filename":"pagenavigation"}', '{"position":"1","relative":"1","display":"0"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":"","filename":"vote"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others","authorEmail":"marijnh@gmail.com","authorUrl":"http:\\/\\/codemirror.net\\/","version":"5.28","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":"","filename":"codemirror"}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"September 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":"","filename":"none"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2017","author":"Ephox Corporation","copyright":"Ephox Corporation","authorEmail":"N\\/A","authorUrl":"http:\\/\\/www.tinymce.com","version":"4.5.7","description":"PLG_TINY_XML_DESCRIPTION","group":"","filename":"tinymce"}', '{"skin":"0","skin_admin":"0","mode":"1","mobile":"0","drag_drop":"1","path":"","entity_encoding":"raw","lang_mode":"0","lang_code":"en","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","use_config_textfilters":"0","invalid_elements":"script,applet,iframe","valid_elements":"","extended_elements":",+a[*],+i[*],+em[*],+li[*],+span[*],+div[*],+ul[*],+li[*],","html_height":"550","html_width":"750","resizing":"1","resize_horizontal":"1","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","colors":"1","table":"1","smilies":"1","hr":"1","link":"1","media":"1","print":"1","directionality":"1","fullscreen":"1","alignment":"1","visualchars":"1","visualblocks":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","image_advtab":"1","code_sample":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_checkboxes","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION","group":"","filename":"checkboxes"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_color","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_COLOR_XML_DESCRIPTION","group":"","filename":"color"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_editor","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_EDITOR_XML_DESCRIPTION","group":"","filename":"editor"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_imagelist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION","group":"","filename":"imagelist"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_integer","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_INTEGER_XML_DESCRIPTION","group":"","filename":"integer"}', '{"multiple":"0","first":"1","last":"100","step":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_list","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_LIST_XML_DESCRIPTION","group":"","filename":"list"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":"","filename":"article"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":"","filename":"image"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":"","filename":"readmore"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 0, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":"","filename":"languagefilter"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":"","filename":"p3p"}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":"","filename":"cache"}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":"","filename":"debug"}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":"","filename":"log"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION","group":"","filename":"redirect"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":"","filename":"remember"}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":"","filename":"sef"}', '{}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":"","filename":"logout"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":"","filename":"contactcreator"}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":"","filename":"profile"}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":"","filename":"languagecode"}', '{}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":"","filename":"joomlaupdate"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":"","filename":"extensionupdate"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 1, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":"","filename":"recaptcha"}', '{"public_key":"6LcrGdsSAAAAAESi204sLHrxcIz9lvLOjj9FPOxw ","private_key":"6LcrGdsSAAAAAEYXaESQBw7zcxgXXrv6XKiMIA7F","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":"","filename":"highlight"}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 0, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":"","filename":"totp"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":"","filename":"cookie"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":"","filename":"yubikey"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"October 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.1","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"October 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.1","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"October 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.6","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 0, 'PKG_JOOMLA', 'package', 'pkg_joomla', '', 0, 1, 1, 1, '{"legacy":false,"name":"PKG_JOOMLA","type":"package","creationDate":"2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"2.5.0","description":"PKG_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'RokPad', 'plugin', 'rokpad', 'editors', 0, 1, 1, 0, '{"name":"RokPad","type":"plugin","creationDate":"August 30, 2018","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2018 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.10","description":"\\n        <div class=\\"rokpad-description\\">\\n        <img src=\\"..\\/plugins\\/editors\\/rokpad\\/assets\\/admin\\/images\\/rokpad.jpg\\" class=\\"img-padding\\" \\/><h1>RokPad<\\/h1>\\n        <h2>The Power of Desktop Text Editor in a Joomla!<\\/h2>\\n        <p>Ever wished you could use a powerful desktop text editor such as Textmate, SublimeText, or UltraEdit directly on a Joomla! web site?  Now with RokPad we provide many features and capabilities that traditionally would only be found in a powerful desktop editor.  RokPad provides advanced functions such as an Ajax saving action, syntax highlighting, configurable themes, multiple cursors and selections, shortcut keys, multiple language support, and many other incredible features.<\\/p>\\n\\n        <h2>Key Features:<\\/h2>\\n        <ul class=\\"features\\">\\n\\t\\t\\t<li>Code Highlighter built on the great ACE Editor<\\/li>\\n\\t        <li>Support for CSS, HTML, JavaScript, JSON, LESS, Markdown, PHP, SQL, Plain Text, Textile, XML and more...<\\/li>\\n\\t        <li>Ajax save and Automatic Save options. You''ll never loose your content again, nor wait until the page has finished reloading after a save!<\\/li>\\n\\t        <li>Save, Undo, Redo, Goto line, Advanced Search and Search &amp; Replace, Full Screen. Settings like Themes, Font Size, Code Folding, Wrap Mode, Invisible Characters, Print Margin, Highlight of selected word<\\/li>\\n\\t        <li>26 Themes to choose from<\\/li>\\n\\t        <li>Resizable Editor by dragging the Statusbar<\\/li>\\n\\t        <li>Keyboard shortcuts<\\/li>\\n\\t        <li>Brackets match<\\/li>\\n\\t        <li>Multiple cursors and selections<\\/li>\\n\\t        <li>Vertical Selection<\\/li>\\n\\t        <li>Ability to insert at multiple locations xtd-buttons shortcodes, all at once.<\\/li>\\n\\t        <li>Shortcodes and Universal Tag Insertion<\\/li>\\n\\t        <li>Drag &amp; Drop of text from external applications such as other Browser Tabs\\/windows or Native Applications (Supported on Firefox, Chrome, IE10 and Safari)<\\/li>\\n\\t        <li>Import local files by Drag &amp; Drop directly from your desktop! (Supported on Firefox, Chrome, IE10 and Safari 6+)<\\/li>\\n\\t        <li>And much more!<\\/li>\\n        <\\/ul>\\n        <\\/div>\\n        ","group":"","filename":"rokpad"}', '{"autosave-enabled":"0","autosave-time":"5","theme":"fluidvision","font-size":"12px","fold-style":"markbeginend","use-wrap-mode":"free","selection-style":"1","highlight-active-line":"1","highlight-selected-word":"1","show-invisibles":"0","show-gutter":"1","show-print-margin":"1","fade-fold-widgets":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10050, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10051, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10088, 0, 'RokCommon', 'library', 'lib_rokcommon', '', 0, 1, 1, 0, '{"name":"RokCommon","type":"library","creationDate":"August 4, 2016","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2016 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"3.2.5","description":"RokCommon Shared Library","group":"","filename":"lib_rokcommon"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10056, 10090, 'System - RokCommon', 'plugin', 'rokcommon', 'system', 0, 1, 1, 0, '{"name":"System - RokCommon","type":"plugin","creationDate":"August 21, 2018","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2018 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"3.2.6","description":"RokCommon System Plugin","group":"","filename":"rokcommon"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10057, 10091, 'RokSprocket', 'component', 'com_roksprocket', '', 1, 1, 0, 0, '{"name":"RokSprocket","type":"component","creationDate":"February 11, 2019","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2019 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.26","description":"RokSprocket","group":"","filename":"roksprocket"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10058, 10091, 'RokSprocket Module', 'module', 'mod_roksprocket', '', 0, 1, 1, 0, '{"name":"RokSprocket Module","type":"module","creationDate":"February 11, 2019","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2019 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.26","description":"RokSprocket makes it easy to display content in a dynamic, visual layout.","group":"","filename":"mod_roksprocket"}', '{"run_content_plugins":"onmodule"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10059, 10091, 'System - RokSprocket', 'plugin', 'roksprocket', 'system', 0, 1, 1, 0, '{"name":"System - RokSprocket","type":"plugin","creationDate":"February 11, 2019","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2019 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.26","description":"RokSprocket System Plugin","group":"","filename":"roksprocket"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10060, 10091, 'Content - RokInjectModule', 'plugin', 'rokinjectmodule', 'content', 0, 1, 1, 0, '{"name":"Content - RokInjectModule","type":"plugin","creationDate":"February 11, 2019","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2019 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.26","description":"RokInjectModule Content Plugin.  Use format [module-{moduleid}] in your article to inject a module. You can also specify a style, eg: [module-28 style=xhtml]","group":"","filename":"rokinjectmodule"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10065, 0, 'Installer', 'plugin', 'roksprocket_installer', 'system', 0, 0, 1, 0, '{"name":"Installer","type":"plugin","creationDate":"May 26, 2017","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2017 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.21","description":"RokSprocket for Joomla! v2.1.21","group":"","filename":"roksprocket_installer"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(801, 0, 'weblinks', 'package', 'pkg_weblinks', '', 0, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB) Language Pack","type":"package","creationDate":"October 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.1.1","description":"en-GB language pack","group":"","filename":"pkg_en-GB"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_module","type":"plugin","creationDate":"October 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_MODULE_XML_DESCRIPTION","group":"","filename":"module"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{"name":"plg_system_updatenotification","type":"plugin","creationDate":"May 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION","group":"","filename":"updatenotification"}', '{"lastrun":1559571421}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{"name":"plg_system_stats","type":"plugin","creationDate":"November 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_STATS_XML_DESCRIPTION","group":"","filename":"stats"}', '{"mode":3,"lastrun":"","unique_id":"54cd58a735fef615ac745f2afb3bb41a06972acd","interval":12}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_menu","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION","group":"","filename":"menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{"name":"com_fields","type":"component","creationDate":"March 2016","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{"name":"plg_system_fields","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_SYSTEM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_calendar","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CALENDAR_XML_DESCRIPTION","group":"","filename":"calendar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10082, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"showSiteName":"0","logoFile":"","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10081, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature","backgroundcolor":"#eee"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10084, 0, 'jp-city', 'template', 'jp-city', '', 0, 1, 1, 0, '{"name":"jp-city","type":"template","creationDate":"July 2015","author":"JoomlaPlates","copyright":"Copyright (C) JoomlaPlates","authorEmail":"support@JoomlaPlates.com","authorUrl":"http:\\/\\/www.JoomlaPlates","version":"1.0.001","description":"City Theme by JoomlaPlates","group":"","filename":"templateDetails"}', '{"config":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10085, 0, 'jp-inspire', 'template', 'jp-inspire', '', 0, 1, 1, 0, '{"name":"jp-inspire","type":"template","creationDate":"July 2015","author":"JoomlaPlates","copyright":"Copyright (C) JoomlaPlates","authorEmail":"support@JoomlaPlates.com","authorUrl":"http:\\/\\/www.JoomlaPlates","version":"1.0.001","description":"Inspire Theme by JoomlaPlates","group":"","filename":"templateDetails"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, -1),
(10086, 0, 'bluestork', 'template', 'bluestork', '', 1, 1, 1, 0, '{"name":"bluestork","type":"template","creationDate":"07\\/02\\/09","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"TPL_BLUESTORK_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"showSiteName":"0","textBig":"0","highContrast":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_phpversioncheck","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION","group":"","filename":"phpversioncheck"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_media","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_radio","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_RADIO_XML_DESCRIPTION","group":"","filename":"radio"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_sql","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_SQL_XML_DESCRIPTION","group":"","filename":"sql"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_text","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXT_XML_DESCRIPTION","group":"","filename":"text"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_textarea","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION","group":"","filename":"textarea"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_url","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_URL_XML_DESCRIPTION","group":"","filename":"url"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_user","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USER_XML_DESCRIPTION","group":"","filename":"user"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_usergrouplist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION","group":"","filename":"usergrouplist"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_contact","type":"plugin","creationDate":"October 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{"name":"com_associations","type":"component","creationDate":"Januar 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_ASSOCIATIONS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{"name":"plg_content_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_CONTENT_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 0, 1, 0, '{"name":"mod_sampledata","type":"module","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"MOD_SAMPLEDATA_XML_DESCRIPTION","group":"","filename":"mod_sampledata"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{"name":"plg_sampledata_blog","type":"plugin","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION","group":"","filename":"blog"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10089, 10090, 'RokCommon', 'library', 'rokcommon', '', 0, 1, 1, 0, '{"name":"RokCommon","type":"library","creationDate":"August 21, 2018","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2018 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"3.2.6","description":"RocketTheme shared library","group":"","filename":"lib_rokcommon"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10090, 0, 'pkg_rokcommon', 'package', 'pkg_rokcommon', '', 0, 1, 1, 0, '{"name":"pkg_rokcommon","type":"package","creationDate":"August 21, 2018","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2018 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"3.2.6","description":"RocketTheme shared library","group":"","filename":"pkg_rokcommon"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10091, 0, 'pkg_roksprocket', 'package', 'pkg_roksprocket', '', 0, 1, 1, 0, '{"name":"pkg_roksprocket","type":"package","creationDate":"February 11, 2019","author":"RocketTheme, LLC","copyright":"(C) 2005 - 2019 RocketTheme, LLC. All rights reserved.","authorEmail":"support@rockettheme.com","authorUrl":"http:\\/\\/www.rockettheme.com","version":"2.1.26","description":"RokSprocket","group":"","filename":"pkg_roksprocket"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE IF NOT EXISTS `#__fields` (
`id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
`id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE IF NOT EXISTS `#__finder_filters` (
`filter_id` int(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` mediumtext NOT NULL,
  `params` longtext
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE IF NOT EXISTS `#__finder_links` (
`link_id` int(10) unsigned NOT NULL,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(400) DEFAULT NULL,
  `description` text,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_links_terms0`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms1`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms2`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms3`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms4`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms5`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms6`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms7`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms8`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_terms9`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsa`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsb`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsc`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsd`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termse`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_links_termsf`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_taxonomy`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy` (
`id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

INSERT INTO `#__finder_taxonomy` (`id`, `parent_id`, `title`, `state`, `access`, `ordering`) VALUES
(1, 0, 'ROOT', 0, 0, 0);

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_terms`;
CREATE TABLE IF NOT EXISTS `#__finder_terms` (
`term_id` int(10) unsigned NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_terms_common`;
CREATE TABLE IF NOT EXISTS `#__finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

INSERT INTO `#__finder_terms_common` (`term`, `language`) VALUES
('a', 'en'),
('about', 'en'),
('after', 'en'),
('ago', 'en'),
('all', 'en'),
('am', 'en'),
('an', 'en'),
('and', 'en'),
('ani', 'en'),
('any', 'en'),
('are', 'en'),
('aren''t', 'en'),
('as', 'en'),
('at', 'en'),
('be', 'en'),
('but', 'en'),
('by', 'en'),
('for', 'en'),
('from', 'en'),
('get', 'en'),
('go', 'en'),
('how', 'en'),
('if', 'en'),
('in', 'en'),
('into', 'en'),
('is', 'en'),
('isn''t', 'en'),
('it', 'en'),
('its', 'en'),
('me', 'en'),
('more', 'en'),
('most', 'en'),
('must', 'en'),
('my', 'en'),
('new', 'en'),
('no', 'en'),
('none', 'en'),
('not', 'en'),
('noth', 'en'),
('nothing', 'en'),
('of', 'en'),
('off', 'en'),
('often', 'en'),
('old', 'en'),
('on', 'en'),
('onc', 'en'),
('once', 'en'),
('onli', 'en'),
('only', 'en'),
('or', 'en'),
('other', 'en'),
('our', 'en'),
('ours', 'en'),
('out', 'en'),
('over', 'en'),
('page', 'en'),
('she', 'en'),
('should', 'en'),
('small', 'en'),
('so', 'en'),
('some', 'en'),
('than', 'en'),
('thank', 'en'),
('that', 'en'),
('the', 'en'),
('their', 'en'),
('theirs', 'en'),
('them', 'en'),
('then', 'en'),
('there', 'en'),
('these', 'en'),
('they', 'en'),
('this', 'en'),
('those', 'en'),
('thus', 'en'),
('time', 'en'),
('times', 'en'),
('to', 'en'),
('too', 'en'),
('true', 'en'),
('under', 'en'),
('until', 'en'),
('up', 'en'),
('upon', 'en'),
('use', 'en'),
('user', 'en'),
('users', 'en'),
('veri', 'en'),
('version', 'en'),
('very', 'en'),
('via', 'en'),
('want', 'en'),
('was', 'en'),
('way', 'en'),
('were', 'en'),
('what', 'en'),
('when', 'en'),
('where', 'en'),
('whi', 'en'),
('which', 'en'),
('who', 'en'),
('whom', 'en'),
('whose', 'en'),
('why', 'en'),
('wide', 'en'),
('will', 'en'),
('with', 'en'),
('within', 'en'),
('without', 'en'),
('would', 'en'),
('yes', 'en'),
('yet', 'en'),
('you', 'en'),
('your', 'en'),
('yours', 'en');

DROP TABLE IF EXISTS `#__finder_tokens`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `#__finder_types`;
CREATE TABLE IF NOT EXISTS `#__finder_types` (
`id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
`lang_id` int(11) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 0, 1);

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
`id` int(11) NOT NULL,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned DEFAULT NULL,
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=247 ;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 161, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 99, 104, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 100, 101, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 102, 103, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 105, 108, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 106, 107, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 109, 114, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 110, 111, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 112, 113, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 123, 124, 0, '*', 1),
(17, 'main', 'com_search', 'Search', '', 'Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 115, 116, 0, '*', 1),
(18, 'main', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', 1, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 117, 122, 0, '*', 1),
(19, 'main', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', 1, 18, 2, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 118, 119, 0, '*', 1),
(20, 'main', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 1, 18, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks-cat', 0, '', 120, 121, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 97, 98, 0, '*', 1),
(241, 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 1, 'class:joomlaupdate', 0, '{}', 157, 158, 0, '', 1),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=article&id=53', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"Joomla Template Exchnage- Joomlaplates.com","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 11, 12, 1, '*', 0),
(102, 'mainmenu', 'Features', 'theme-features', '', 'theme-features', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 13, 30, 0, '*', 0),
(207, 'mainmenu', 'Smooth Scroll Function', 'smooth-scroll-function', '', 'theme-features/smooth-scroll-function', 'index.php?option=com_content&view=article&id=32', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"0","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 18, 19, 0, '*', 0),
(103, 'mainmenu', 'Module Variations', 'module-variations', '', 'theme-features/module-variations', 'index.php?option=com_content&view=article&id=1', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 14, 15, 0, '*', 0),
(104, 'mainmenu', 'UiKit / Typography', 'typography', '', 'theme-features/typography', 'index.php?option=com_content&view=article&id=4', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 24, 25, 0, '*', 0),
(107, 'mainmenu', 'Joomla', 'joomla', '', 'joomla', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 79, 96, 0, '*', 0),
(108, 'topmenu', 'Scroll to Top A', '2011-05-02-12-32-40', '', '2011-05-02-12-32-40', '#top-a', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"scroll","menu_image":"","menu_text":1}', 125, 126, 0, '*', 0),
(208, 'mainmenu', 'Sticky Menu = On', '2013-06-22-21-23-39', '', 'theme-features/2013-06-22-21-23-39', '?style=default', 'url', 1, 102, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 26, 27, 0, '*', 0),
(109, 'topmenu', 'Typography', '2011-05-02-12-33-12', '', '2011-05-02-12-33-12', 'index.php?option=com_content&view=article&id=4&Itemid=104', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 127, 128, 0, '*', 0),
(110, 'topmenu', 'News', 'news', '', 'news', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"127","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 129, 130, 0, '*', 0),
(111, 'sidebarmenu', 'Sample Levels', 'sample-levels', '', 'sample-levels', 'index.php?option=com_content&view=article&id=5', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 131, 142, 0, '*', 0),
(112, 'sidebarmenu', 'Level 2', 'level-2', '', 'sample-levels/level-2', 'index.php?option=com_content&view=article&id=5', 'component', 1, 111, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 132, 133, 0, '*', 0),
(113, 'sidebarmenu', 'Level 2', 'level-21', '', 'sample-levels/level-21', 'index.php?option=com_content&view=article&id=5', 'component', 1, 111, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 134, 139, 0, '*', 0),
(114, 'sidebarmenu', 'Level 3', 'level-3', '', 'sample-levels/level-21/level-3', 'index.php?option=com_content&view=article&id=5', 'component', 1, 113, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 135, 138, 0, '*', 0),
(115, 'sidebarmenu', 'Level 4', 'level-4', '', 'sample-levels/level-21/level-3/level-4', 'index.php?option=com_content&view=article&id=5', 'component', 1, 114, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 136, 137, 0, '*', 0),
(116, 'sidebarmenu', 'Level 2', 'level-22', '', 'sample-levels/level-22', 'index.php?option=com_content&view=article&id=5', 'component', 1, 111, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 140, 141, 0, '*', 0),
(117, 'sidebarmenu', 'Accordion A', 'accordion-a', '', 'accordion-a', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 143, 150, 0, '*', 0),
(118, 'sidebarmenu', 'Level 2', 'level-2', '', 'accordion-a/level-2', 'index.php?option=com_content&view=article&id=5', 'component', 1, 117, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 144, 145, 0, '*', 0),
(119, 'sidebarmenu', 'Level 2', 'level-21', '', 'accordion-a/level-21', 'index.php?option=com_content&view=article&id=5', 'component', 1, 117, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 146, 147, 0, '*', 0),
(120, 'sidebarmenu', 'Level 2', 'level-22', '', 'accordion-a/level-22', 'index.php?option=com_content&view=article&id=5', 'component', 1, 117, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 148, 149, 0, '*', 0),
(121, 'sidebarmenu', 'Accordion B', 'accordion-b', '', 'accordion-b', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 151, 156, 0, '*', 0),
(122, 'sidebarmenu', 'Level 2', 'level-2', '', 'accordion-b/level-2', 'index.php?option=com_content&view=article&id=5', 'component', 1, 121, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 152, 153, 0, '*', 0),
(123, 'sidebarmenu', 'Level 2', 'level-21', '', 'accordion-b/level-21', 'index.php?option=com_content&view=article&id=5', 'component', 1, 121, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 154, 155, 0, '*', 0),
(124, 'mainmenu', 'Joomla Content', 'joomla-content', '', 'joomla/joomla-content', '', 'separator', 1, 107, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 80, 89, 0, '*', 0),
(126, 'mainmenu', 'Category Blog - 3 Column', 'category-blog-3-column', '', 'joomla/joomla-content/category-blog-3-column', 'index.php?option=com_content&view=category&layout=blog&id=7', 'component', 1, 124, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"3","num_columns":"3","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 87, 88, 0, '*', 0),
(127, 'mainmenu', 'Category Blog - 2 Column', 'category-blog-2-column', '', 'joomla/joomla-content/category-blog-2-column', 'index.php?option=com_content&view=category&layout=blog&id=7', 'component', 1, 124, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"4","num_columns":"2","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 85, 86, 0, '*', 0),
(128, 'mainmenu', 'Single Article', 'single-article', '', 'joomla/joomla-content/single-article', 'index.php?option=com_content&view=article&id=8', 'component', 1, 124, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 81, 82, 0, '*', 0),
(132, 'mainmenu', 'Pages', 'pages', '', 'pages', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 65, 78, 0, '*', 0),
(150, 'mainmenu', 'Joomla Content - Sidebars', 'joomla-content-sidebars', '', 'joomla/joomla-content-sidebars', '', 'separator', 1, 107, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 90, 95, 0, '*', 0),
(151, 'mainmenu', 'Joomla Content, Sidebar Left', 'joomla-content-sidebar-left', '', 'joomla/joomla-content-sidebars/joomla-content-sidebar-left', 'index.php?option=com_content&view=article&id=34', 'component', 1, 150, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 91, 92, 0, '*', 0),
(152, 'mainmenu', 'Joomla Content, Sidebar Right', 'joomla-content-sidebar-right', '', 'joomla/joomla-content-sidebars/joomla-content-sidebar-right', 'index.php?option=com_content&view=article&id=33', 'component', 1, 150, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 93, 94, 0, '*', 0),
(173, 'mainmenu', 'Module Positions', 'module-positions', '', 'theme-features/module-positions', 'index.php?option=com_content&view=article&id=24', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 16, 17, 0, '*', 0),
(175, 'mainmenu', 'Theme Styles', 'theme-styles', '', 'theme-styles', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1}', 31, 60, 0, '*', 0),
(177, 'mainmenu', 'Theme Default', '2013-06-22-21-23-34', '', 'theme-styles/2013-06-22-21-23-34', '?style=default', 'url', 1, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 32, 33, 0, '*', 0),
(178, 'mainmenu', 'Theme Green', '2013-06-22-21-23-35', '', 'theme-styles/2013-06-22-21-23-35', '?style=green', 'url', 1, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 34, 35, 0, '*', 0),
(181, 'mainmenu', 'Sticky Menu = Off', 'sticky-menu-off', '', 'theme-features/sticky-menu-off', 'index.php?option=com_content&view=article&id=7', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 28, 29, 0, '*', 0),
(197, 'mainmenu', 'Real Time Customizing', 'real-time-customizing', '', 'theme-features/real-time-customizing', 'index.php?option=com_content&view=article&id=30', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"0","show_intro":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 22, 23, 0, '*', 0),
(199, 'mainmenu', 'Category Blog - 1 Column', 'category-blog-1-column', '', 'joomla/joomla-content/category-blog-1-column', 'index.php?option=com_content&view=category&layout=blog&id=7', 'component', 1, 124, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"3","num_columns":"1","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"1","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 83, 84, 0, '*', 0),
(205, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 61, 62, 0, '', 1),
(206, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 63, 64, 0, '*', 1),
(212, 'mainmenu', 'Theme Red', '2013-06-22-21-23-41', '', 'theme-styles/2013-06-22-21-23-41', '?style=red', 'url', 1, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 36, 37, 0, '*', 0),
(213, 'mainmenu', 'Theme Blue I', '2013-06-22-21-23-43', '', 'theme-styles/2013-06-22-21-23-43', '?style=blue', 'url', -2, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 42, 43, 0, '*', 0),
(228, 'mainmenu', 'Unlimited Backgrounds', 'unlimited-backgrounds', '', 'theme-features/unlimited-backgrounds', 'index.php?option=com_content&view=article&id=52', 'component', 1, 102, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 20, 21, 0, '*', 0),
(224, 'mainmenu', 'Pricing Tables', 'pricing-tables', '', 'pages/pricing-tables', 'index.php?option=com_content&view=article&id=49', 'component', 1, 132, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"1","show_intro":"","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 66, 67, 0, '*', 0),
(225, 'mainmenu', 'Mosaic Portfolio', 'mosaic-portfolio', '', 'pages/mosaic-portfolio', 'index.php?option=com_content&view=article&id=51', 'component', 1, 132, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"1","show_intro":"","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 74, 75, 0, '*', 0),
(226, 'mainmenu', 'Article Grids', 'article-grids', '', 'pages/article-grids', 'index.php?option=com_content&view=article&id=46', 'component', 1, 132, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"1","show_intro":"","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 76, 77, 0, '*', 0),
(227, 'mainmenu', 'Mosaic Gallery', 'mosaic-gallery', '', 'pages/mosaic-gallery', 'index.php?option=com_content&view=article&id=48', 'component', 1, 132, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"1","show_intro":"","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 72, 73, 0, '*', 0),
(229, 'mainmenu', 'Theme Dark', '2013-06-22-21-23-45', '', 'theme-styles/2013-06-22-21-23-45', '?style=dark', 'url', 1, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 38, 39, 0, '*', 0),
(230, 'mainmenu', 'Theme Green', '2013-06-22-21-23-46', '', 'theme-styles/2013-06-22-21-23-46', '?style=green', 'url', -2, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 50, 51, 0, '*', 0),
(231, 'mainmenu', 'Theme Grey', '2013-06-22-21-23-47', '', 'theme-styles/2013-06-22-21-23-47', '?style=grey-bg', 'url', -2, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 40, 41, 0, '*', 0),
(236, 'mainmenu', 'Theme Blue II', '2013-06-22-21-23-52', '', 'theme-styles/2013-06-22-21-23-52', '?style=blue-header', 'url', -2, 175, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 44, 45, 0, '*', 0),
(237, 'mainmenu', 'Theme Blue III', 'menu-left', '', 'theme-styles/menu-left', '?style=blue-bg', 'url', -2, 175, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1}', 46, 47, 0, '*', 0),
(238, 'mainmenu', 'Menu Right', 'menu-right', '', 'theme-styles/menu-right', 'index.php?option=com_content&view=article&id=55', 'component', -2, 175, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 52, 53, 0, '*', 0),
(239, 'mainmenu', 'Theme Left', 'theme-left', '', 'theme-styles/theme-left', 'index.php?option=com_content&view=article&id=37', 'component', -2, 175, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 54, 55, 0, '*', 0),
(240, 'mainmenu', 'Theme Right', 'theme-right', '', 'theme-styles/theme-right', 'index.php?option=com_content&view=article&id=54', 'component', -2, 175, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 56, 57, 0, '*', 0),
(242, 'mainmenu', 'Sample Strips 1', 'sample-strips-1', '', 'pages/sample-strips-1', 'index.php?option=com_content&view=article&id=57', 'component', 1, 132, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"0","link_titles":"1","show_intro":"","info_block_position":"0","info_block_show_title":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 68, 69, 0, '*', 0),
(243, 'mainmenu', 'Sample Strips 2', 'sample-strips-2', '', 'pages/sample-strips-2', 'index.php?option=com_content&view=article&id=58', 'component', 1, 132, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"0","link_titles":"1","show_intro":"","info_block_position":"0","info_block_show_title":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 70, 71, 0, '*', 0),
(244, 'mainmenu', 'Center Menu & Logo', 'center-menu-logo', '', 'theme-styles/center-menu-logo', 'index.php?option=com_content&view=article&id=59', 'component', 1, 175, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","info_block_show_title":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 48, 49, 0, '*', 0),
(245, 'mainmenu', 'Left Menu & Logo', 'left-menu-logo', '', 'theme-styles/left-menu-logo', 'index.php?Itemid=', 'alias', 1, 175, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1}', 58, 59, 0, '*', 0),
(246, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 159, 160, 0, '*', 1);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
`id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0),
(2, 0, 'topmenu', 'Top Menu', '', 0),
(3, 0, 'sidebarmenu', 'Sidebar Menu', '', 0);

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
`message_id` int(10) unsigned NOT NULL,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
`id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned DEFAULT NULL,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=223 ;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(1, 0, 'Main Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"_menu","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(6, 0, 'Unread Messages', '', '', 1, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_unread', 3, 1, '', 1, '*'),
(7, 0, 'Online Users', '', '', 2, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_online', 3, 1, '', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 184, 'Breadcrumbs', '', '', 1, 'breadcrumbs', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{"showHere":"1","showHome":"1","homeText":"Home","showLast":"1","separator":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(19, 100, 'Top B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Primary</p>', 2, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"icon-download","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(20, 181, 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Border</code>', 3, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"icon-twitter","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(21, 180, 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Border</code>', 4, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"icon-mail","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(22, 179, 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Border</code>', 5, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"icon-bubble","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(27, 183, 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Shadow</code>', 1, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-hot","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(28, 182, 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Shadow</code>', 2, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-new","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(29, 0, 'Bottom C', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box</code>', 3, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-free","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(30, 0, 'Bottom C', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box</code>', 4, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-top","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(31, 107, 'Footer  Menu', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"topmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(34, 99, 'Top B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Primary</p>', 1, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"mod-clean icon-login","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(35, 98, 'Top B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Primary</p>', 1, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"icon-cart","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(36, 0, 'Inner Top', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 1, 'innertop', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(38, 87, 'Logo', '', '<div style="margin:20px"><p style="font-size:2em;border:1px solid;padding:0 10px"><i class="uk-icon-university"></i>CITY</p></div>', 1, 'logo', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(207, 185, 'Home Top B Left', '', '<a data-uk-lightbox title="Sample Image" href="images/joomlaplates/demo-001.jpg"><img class="img-border" src="images/joomlaplates/demo-001.jpg" alt="Demo Image"></a>\r\n\r\n', 1, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(39, 0, 'Login', '', '', 2, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(40, 102, 'Search', '', '', 1, 'search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"label":"","width":"","text":"","button":"0","button_pos":"right","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(42, 116, 'Sidebar Menu', '', '', 1, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(43, 135, 'Sidebar A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(44, 134, 'Sidebar A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(57, 137, 'Sidebar B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 3, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(62, 178, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Default</p>', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"mod-clean1","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(63, 177, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Default</p>', 2, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"mod-clean2","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(64, 176, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Default</p>', 3, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"mod-clean3","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(80, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{"layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(81, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(130, 109, 'Logo Mobile', '', '<div style="margin:20px"><p style="font-size:2em;border:1px solid;padding:0 10px"><i class="uk-icon-university"></i>CITY</p></div>\r\n\r\n	\r\n', 1, 'logo-small', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(131, 0, 'Main Menu Offcanvas', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"_menu","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(139, 157, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Badge</strong> <code>Success</code></p>', 1, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(140, 156, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Badge</strong> <code>Warning</code></p>', 1, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(141, 158, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Badge</strong> <code>Danger</code></p>', 2, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(142, 0, 'Bottom D', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box</code>', 4, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-free","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(143, 200, 'Bottom D', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box</code>', 5, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-top","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(163, 136, 'Sidebar B', '', '<img src="images/joomlaplates/contact.jpg" alt="contact" />\r\n<p>If you have a question about our themes, please feel free to contact us!</p>\r\n<p>support[at]joomlaplates.com</p>\r\n<p> </p>\r\n<p>Our support Hotline is available 24 Hours a day: (555) 457 865 5711</p>\r\n', 4, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(166, 90, 'Home Headerbar Slideshow', '', '', 1, 'headerbar', 0, '0000-00-00 00:00:00', '2016-05-01 16:23:53', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 0, '{"run_content_plugins":"onmodule","provider":"simple","layout":"features","simple_sort":"manual","display_limit":"\\u221e","features_themes":"slideshow","features_show_title":"1","features_show_article_text":"1","features_previews_length":"\\u221e","features_strip_html_tags":"0","features_show_arrows":"show","features_show_pagination":"0","features_animation":"crossfade","features_autoplay":"0","features_autoplay_delay":"5","features_resize_enable":"0","features_resize_width":"0","features_resize_height":"0","features_title_default":"title","features_description_default":"primary","features_image_default":"primary","features_image_default_custom":"","features_link_default":"primary","features_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(170, 103, 'About Us', '', '<p>JoomlaPlates.com, based in Germany, was founded by Peter Kuhlmann in 2007.</p>\r\n\r\n    <p>We are a small, creative team, specializing in Joomla web-design and template development. Our goal is to create highly-useable, lightweight, and affordable Joomla templates and themes.</p>\r\n<p><a href="#" class="uk-button">Read more</a>\r\n', 2, 'bottom-d', 0, '0000-00-00 00:00:00', '2017-01-26 23:39:30', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(206, 175, 'Testimonials', '', '', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '2016-10-08 21:39:17', '0000-00-00 00:00:00', -2, 'mod_roksprocket', 1, 1, '{"run_content_plugins":"onmodule","provider":"simple","layout":"quotes","simple_sort":"manual","quotes_themes":"default","display_limit":"\\u221e","quotes_previews_length":"5","quotes_strip_html_tags":"0","quotes_items_per_page":"2","quotes_items_per_row":"2","quotes_show_arrows":"show","quotes_show_pagination":"1","quotes_animation":"floatUp","quotes_autoplay":"0","quotes_autoplay_delay":"5","quotes_resize_enable":"0","quotes_resize_width":"0","quotes_resize_height":"0","quotes_description_default":"primary","quotes_image_default":"primary","quotes_image_default_custom":"","quotes_link_default":"primary","quotes_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(173, 106, 'Links', '', '<ul class="uk-list-line">\r\n<li><a target="_blank" href="https://www.joomlaplates.com/forum">Support Forum</a></li>\r\n<li><a target="_blank" href="https://www.joomlaplates.com/support/documentation">Documentation &amp; FAQ</a></li>\r\n<li><a target="_blank" href="https://www.joomlaplates.com/wordpress-themes">Our Wordpress Themes</a></li>\r\n<li><a target="_blank" href="https://www.joomlaplates.com/installation-service">Installation Service</a></li>\r\n<li><a target="_blank" href="https://www.joomlaplates.com/support/template-updates">Template Updates</a></li>\r\n</ul>', 3, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(175, 113, 'Template Features', '', '<div class="uk-grid">\r\n    <div class="uk-width-medium-1-3">\r\n        <ul class="check">\r\n            <li>Joomla 3.x compatible</li>\r\n            <li>44 Module positions</li>\r\n            <li>Unlimited Theme Colors</li>\r\n            <li>Based on Warp7* Framework</li>\r\n            <li>Unlimted Background Colors</li>\r\n            <li>Responsive Slideshow</li>\r\n            <li>Simple Lightbox</li>\r\n            <li>Sticky Mainmenu</li>\r\n        </ul>\r\n    </div>\r\n    <div class="uk-width-medium-1-3">\r\n        <ul class="check">\r\n            <li>Dot Nav Menu</li>\r\n            <li>Real Time Customizer</li>\r\n            <li>300 Google Fonts included</li>\r\n            <li>Unlimited Module Style Colors</li>\r\n            <li>Megamenu with Icons and Subtitles</li>\r\n            <li>Great YooTheme\r\n                <a href="http://getuikit.com/" target="_blank"> UiKit</a> included</li>\r\n            <li>Quickstart Package Included</li>\r\n            <li>Scroll to any section ( modules)</li>\r\n        </ul>\r\n    </div>\r\n    <div class="uk-width-medium-1-3">\r\n        <ul class="check">\r\n            <li>Modern Module Animations</li>\r\n            <li>Off Canvas Menu for Mobile Devices</li>\r\n            <li>Font Awesome Icons</li>\r\n            <li>Fluid and nestable Grid Layout</li>\r\n            <li>HTML5, CSS3, PHP 5.2+ and jQuery.</li>\r\n            <li>Custom Offline and 404 Page</li>\r\n            <li>To-Top Scroller &amp; Custom Copyright</li>\r\n            <li>Full Size Background Images</li>\r\n        </ul>\r\n    </div>\r\n</div>', 1, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(176, 114, 'Module Features', '', '<h3 class="uk-panel-title">Core Features</h3>\r\n<ul class="check">\r\n<li>Module Shortcodes</li>\r\n<li>RokGallery Support</li>\r\n<li>MediaManager Support</li>\r\n<li>Inline Article Details</li>\r\n<li>Dynamic Settings</li>\r\n<li>Inline Article Previews</li>\r\n<li>Advanced Cumulative Filters</li>\r\n<li>Advanced Sorting Rules</li>\r\n<li>Individual Article Display</li>\r\n<li>Individual Article Controls</li>\r\n<li>Responsive Layout Modes</li>\r\n</ul>\r\n<h3 class="uk-panel-title">Layout Modes</h3>\r\n<ul class="check">\r\n<li>Features</li>\r\n<li>Headlines</li>\r\n<li>Mosaic</li>\r\n<li>Strips</li>\r\n<li>Tabs</li>\r\n<li>Lists</li>\r\n</ul>\r\n<h3 class="uk-panel-title">Content Providers</h3>\r\n<ul class="check">\r\n<li>Joomla</li>\r\n<li>K2</li>\r\n<li>Seblod</li>\r\n<li>EasyBlog</li>\r\n<li>Content Builder</li>\r\n<li>FieldsAttach</li>\r\n<li>Zoo</li>\r\n<li>Simple</li>\r\n</ul>', 5, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(177, 117, 'Sidebar A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(182, 122, 'Social Icons', '', '<a href="" class="uk-margin-small-right uk-icon-small uk-icon-facebook-official"></a> \r\n<a href="" class="uk-margin-small-right uk-icon-small uk-icon-twitter-square"></a> \r\n<a href="" class="uk-margin-small-right uk-icon-small uk-icon-google-plus"></a>\r\n<a href="" class="uk-margin-small-right uk-icon-small uk-icon-xing-square"></a>\r\n', 1, 'toolbar-r', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(184, 126, 'Top C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Secondary</p>', 1, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(185, 127, 'Top C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Secondary</p>', 1, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(186, 128, 'Top C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br /><strong>Style</strong> Box Secondary</p>', 2, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(187, 129, 'Bottom B', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Shadow</code>', 2, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-new","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(188, 130, 'Bottom C', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box</code>', 3, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"badge-free","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(189, 131, 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Style: <code>Box Border</code>', 3, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"icon-twitter","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(190, 133, 'Module Variations', '', '<p>The available values for the module parameters vary depending on which template you are using. Check out the <em>Module Variations</em> page of the template to find out which values are available.</p>', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(191, 138, 'Sidebar A Right', '', '<img src="images/joomlaplates/contact.jpg" alt="contact" />\r\n<p>If you have a question about our themes, please feel free to contact us!</p>\r\n<p>support[at]joomlaplates.com</p>\r\n<p> </p>\r\n<p>Our support Hotline is available 24 Hours a day: (555) 457 865 5711</p>\r\n', 2, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(192, 139, 'Sidebar A Right', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 6, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(200, 165, 'Sample Grid', '', '', 1, 'grid', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 1, '{"run_content_plugins":"onmodule","provider":"joomla","layout":"grids","joomla_filters":{"1":{"root":{"category":"11"}}},"joomla_sort":"manual","joomla_sort_manual_append":"after","grids_themes":"basic","display_limit":"∞","grids_columns":"3","grids_previews_length":"18","grids_strip_html_tags":"0","grids_animations":["fade","scale","rotate"],"grids_resize_enable":"0","grids_resize_width":"0","grids_resize_height":"0","grids_title_default":"title","grids_description_default":"primary","grids_image_default":"none","grids_image_default_custom":"","grids_link_default":"primary","grids_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(198, 155, 'Sample Mosaic Gallery', '', '', 1, 'bottom-a', 0, '0000-00-00 00:00:00', '2016-10-05 21:06:22', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 1, '{"run_content_plugins":"onmodule","provider":"joomla","layout":"mosaic","joomla_filters":{"1":{"root":{"category":"11"}}},"joomla_sort":"manual","joomla_sort_manual_append":"after","joomla_sort_automatic_filters":{"1":{"root":{"category":"ascending"}}},"mosaic_themes":"default","display_limit":"9","mosaic_columns":"3","mosaic_previews_length":"10","mosaic_filter_tags":"","mosaic_strip_html_tags":"1","mosaic_items_per_page":"6","mosaic_article_details":"0","mosaic_animations":["fade","scale","rotate"],"mosaic_ordering":["default","title","date","random"],"mosaic_resize_enable":"0","mosaic_resize_width":"0","mosaic_resize_height":"0","mosaic_title_default":"title","mosaic_description_default":"primary","mosaic_image_default":"primary","mosaic_image_default_custom":"","mosaic_link_default":"primary","mosaic_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(199, 164, 'Sample Price Tables', '', '', 1, 'prices', 0, '0000-00-00 00:00:00', '2016-10-05 21:05:46', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 1, '{"run_content_plugins":"onmodule","provider":"simple","layout":"tables","simple_sort":"manual","tables_themes":"product","display_limit":"\\u221e","tables_previews_length":"20","tables_strip_html_tags":"1","tables_items_per_page":"3","tables_items_per_row":"3","tables_show_arrows":"show","tables_show_pagination":"1","tables_animation":"fadeDelay","tables_autoplay":"0","tables_autoplay_delay":"5","tables_resize_enable":"0","tables_resize_width":"0","tables_resize_height":"0","tables_title_default":"title","tables_description_default":"primary","tables_image_default":"primary","tables_image_default_custom":"","tables_link_default":"primary","tables_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(201, 167, 'Sample Mosaic Gallery Module', '', '', 1, 'mosaic', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 1, '{"run_content_plugins":"onmodule","provider":"joomla","layout":"mosaic","joomla_filters":{"1":{"root":{"category":"11"}}},"joomla_sort":"manual","joomla_sort_manual_append":"after","joomla_sort_automatic_filters":{"1":{"root":{"category":"ascending"}}},"mosaic_themes":"gallery","display_limit":"9","mosaic_columns":"3","mosaic_previews_length":"10","mosaic_filter_tags":"","mosaic_strip_html_tags":"1","mosaic_items_per_page":"9","mosaic_article_details":"0","mosaic_animations":["fade","scale","rotate"],"mosaic_ordering":["default","title","date","random"],"mosaic_resize_enable":"0","mosaic_resize_width":"0","mosaic_resize_height":"0","mosaic_title_default":"title","mosaic_description_default":"primary","mosaic_image_default":"primary","mosaic_image_default_custom":"","mosaic_link_default":"primary","mosaic_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(203, 172, 'Dot Nav Menu', '', '<ul class="uk-dotnav uk-flex-column">\r\n<li><a title="Scroll to Top-A" href="#top-a" data-uk-smooth-scroll="" data-uk-tooltip="{pos:''left''}">Top A</a></li>\r\n<li><a title="Scroll to Bottom-A" href="#bottom-a" data-uk-smooth-scroll="" data-uk-tooltip="{pos:''left''}">Bottom A</a></li>\r\n<li><a title="Scroll to Bottom-B" href="#bottom-b" data-uk-smooth-scroll="" data-uk-tooltip="{pos:''left''}">Bottom B</a></li>\r\n<li><a title="Scroll to Bottom-C" href="#bottom-c" data-uk-smooth-scroll="" data-uk-tooltip="{pos:''left''}">Bottom C</a></li>\r\n<li><a title="Scroll to Bottom-D" href="#bottom-d" data-uk-smooth-scroll="" data-uk-tooltip="{pos:''left''}">Bottom D</a></li>\r\n</ul>', 1, 'absolute', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(205, 174, 'Contact', '', '<p><i class="uk-icon-home"></i> JoomlaPLates<br/>\r\n<i class="uk-icon-phone"></i> +49 6027.979.5825<br/>\r\n<i class="uk-icon-phone"></i> +49 176.23.569515<br/>\r\n<i class="uk-icon-envelope-o"></i> info@mail.com<br/>\r\n<i class="uk-icon-clock-o"></i> Mo-Fr: 10.00-18.00</p>\r\n<br/>\r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-facebook-official"></a> \r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-twitter-square"></a> \r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-google-plus"></a>\r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-xing-square"></a>', 1, 'bottom-d', 519, '2017-03-27 10:41:50', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(208, 186, 'Home Top B Right', '', '\r\n    <h3>Grill is another great, colorful Joomla Template</h3>\r\n    <hr class="hrcolor" />\r\n    <h5>The generally accepted differences between barbecuing and grilling are cooking durations and the types of heat use.</h5>\r\n    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n    <p>\r\n        <a class="uk-button uk-uk-button-primary" href="#">Read more</a>\r\n    </p>\r\n', 1, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(211, 192, 'Sample Strips', '', '', 1, 'strips', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 0, '{"run_content_plugins":"onmodule","provider":"joomla","layout":"strips","joomla_filters":{"1":{"root":{"category":"11"}}},"joomla_sort":"automatic","joomla_sort_manual_append":"after","strips_themes":"cards","display_limit":"8","strips_previews_length":"14","strips_strip_html_tags":"1","strips_items_per_page":"4","strips_items_per_row":"4","strips_show_arrows":"show","strips_show_pagination":"1","strips_animation":"fadeDelay","strips_autoplay":"0","strips_autoplay_delay":"5","strips_resize_enable":"0","strips_resize_width":"0","strips_resize_height":"0","strips_title_default":"title","strips_image_default":"primary","strips_description_default":"primary","strips_image_default_custom":"","strips_link_default":"primary","strips_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(212, 193, 'Footer Right', '', 'Copyright © 2016 Joomla Template Exchange - <a title="Joomla Templates" href="https://www.Joomlaplates.com">Joomlaplates.com</a>. All Rights Reserved', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(213, 194, 'Toolbar Left', '', '<p><i class="uk-icon-small uk-icon-phone-square"></i> Call us Today: +49 6027.9795824</p>\r\n', 1, 'toolbar-l', 0, '0000-00-00 00:00:00', '2017-01-24 19:37:27', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(214, 195, 'Home Main Top', '', '<img style="max-width:200px" class="uk-align-left" src="images/joomlaplates/welcome.jpg" alt="Demo" /><h3>Welcome to our Website</h3>\r\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\r\n<a class="uk-button" href="#">Read More</a>', 1, 'main-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(215, 196, 'Theme Features', '', '<h4 class="text-primary-color">Additionally, this theme comes with a built-in real-time customizer for easier CSS editing</h4>\r\n<p>You have unlimited layout options and many different color variations. The left sidebar; where the mainmenu is published may have any width in pixel or percent and any color you want.</p>\r\n<hr />\r\n<div class="uk-grid">\r\n    <div class="uk-width-medium-1-2">\r\n\r\n            <i class="uk-icon-check"></i> Unlimited Theme Colors</p>\r\n        <p>\r\n            <i class="uk-icon-check"></i> 44 Module Positions</p>\r\n        <p>\r\n            <i class="uk-icon-check"></i> Responsive Slideshow</p>\r\n        <p>\r\n            <i class="uk-icon-check"></i> Off Canvas Menu</p>      </div>\r\n    <div class="uk-width-medium-1-2">\r\n\r\n            <i class="uk-icon-check"></i> Sticky Mainmenu</p>\r\n        <p>\r\n            <i class="uk-icon-check"></i> Real-Time Customizer</p>\r\n        <p>\r\n            <i class="uk-icon-check"></i> 300 Google Fonts</p>    \r\n        <p>\r\n            <i class="uk-icon-check"></i> Dot Nav Menu</p>  \r\n      </div>\r\n</div>\r\n<hr />\r\n<article class="uk-comment">\r\n    <header class="uk-comment-header">\r\n        <img class="uk-comment-avatar" src="images/joomlaplates/placeholder_avatar.svg" alt="placeholder">\r\n        <h4 class="uk-comment-title">Joshua</h4>\r\n        <div class="uk-comment-meta">12 days ago | Profile | #</div>\r\n    </header>\r\n    <div class="uk-comment-meta">Just as the title says. I had an issue with installing a template I purchased from them, and they were fast, reliable and efficient in helping me. I would certainly recommend their products and services to anyone. </div>\r\n</article>', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(216, 197, 'Toolbar Left', '', '', 1, 'toolbar-l', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"topmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(217, 198, 'Sample Strips', '', '', 1, 'main-top', 0, '0000-00-00 00:00:00', '2017-01-25 01:25:37', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 0, '{"run_content_plugins":"onmodule","provider":"joomla","layout":"strips","joomla_filters":{"1":{"root":{"category":"11"}}},"joomla_sort":"automatic","joomla_sort_manual_append":"after","strips_themes":"separated","display_limit":"8","strips_previews_length":"14","strips_strip_html_tags":"1","strips_items_per_page":"3","strips_items_per_row":"3","strips_show_arrows":"show","strips_show_pagination":"1","strips_animation":"fadeDelay","strips_autoplay":"0","strips_autoplay_delay":"5","strips_resize_enable":"0","strips_resize_width":"0","strips_resize_height":"0","strips_title_default":"title","strips_image_default":"primary","strips_description_default":"primary","strips_image_default_custom":"","strips_link_default":"primary","strips_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(218, 199, 'Home Bottom B', '', '<div class="uk-margin-large-top uk-margin-large-bottom"><h1>WONDERFUL PLACES ALL OVER THE WORLD</h1>\r\n<p>Each section where the modules are stored may have their own background color</p></div>', 1, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(219, 201, 'Recent From Blog', '', '', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 1, '{"run_content_plugins":"onmodule","provider":"simple","layout":"strips","simple_sort":"manual","strips_themes":"separated","display_limit":"\\u221e","strips_previews_length":"20","strips_strip_html_tags":"1","strips_items_per_page":"1","strips_items_per_row":"1","strips_show_arrows":"show","strips_show_pagination":"1","strips_animation":"fadeDelay","strips_autoplay":"0","strips_autoplay_delay":"5","strips_resize_enable":"0","strips_resize_width":"0","strips_resize_height":"0","strips_title_default":"title","strips_description_default":"primary","strips_image_default":"primary","strips_image_default_custom":"","strips_link_default":"primary","strips_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*'),
(221, 203, 'Socials', '', '<p>If you have a question about our themes, please feel free to contact us!</p>\r\n<br/>\r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-facebook-official"></a> \r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-twitter-square"></a> \r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-google-plus"></a>\r\n<a href="/warp-7/city/" class="uk-margin-small-right uk-icon-small uk-icon-xing-square"></a>', 1, 'bottom-d', 0, '0000-00-00 00:00:00', '2017-01-29 23:07:04', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(220, 202, 'Features', '', '<p><i class="uk-icon-angle-right"></i> Unlimited Theme Colors</p>\r\n<p><i class="uk-icon-angle-right"></i> Based on Warp7* Framework</p>\r\n<p><i class="uk-icon-angle-right"></i> Responsive Slideshow &amp; Grid</p>\r\n<p><i class="uk-icon-angle-right"></i> Simple Lightbox &amp; Overlay</p>\r\n<p><i class="uk-icon-angle-right"></i> Sticky Mainmenu &amp; Megamenu</p>\r\n<p><i class="uk-icon-angle-right"></i> Real-Time Customizer</p>', 1, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*');
INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(222, 204, 'Home Headerbar Slideshow (2)', '', '', 1, 'headerbar', 0, '0000-00-00 00:00:00', '2016-05-01 16:23:53', '0000-00-00 00:00:00', 1, 'mod_roksprocket', 1, 0, '{"run_content_plugins":"onmodule","provider":"simple","layout":"features","simple_sort":"manual","display_limit":"\\u221e","features_themes":"slideshow2","features_show_title":"1","features_show_article_text":"1","features_previews_length":"\\u221e","features_strip_html_tags":"0","features_show_arrows":"hide","features_show_pagination":"0","features_animation":"crossfade","features_autoplay":"0","features_autoplay_delay":"5","features_resize_enable":"0","features_resize_width":"0","features_resize_height":"0","features_title_default":"title","features_description_default":"primary","features_image_default":"primary","features_image_default_custom":"","features_link_default":"primary","features_link_default_custom":"","cache":"0","moduleclass_sfx":"","module_cache":"1","cache_time":"900"}', 0, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 0),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, -101),
(19, 103),
(20, 103),
(21, 103),
(22, 103),
(27, 103),
(28, 103),
(29, 103),
(30, 103),
(31, 0),
(34, 103),
(35, 103),
(36, 103),
(38, -178),
(38, -177),
(39, 0),
(40, 0),
(42, 101),
(42, 111),
(42, 112),
(42, 113),
(42, 114),
(42, 115),
(42, 116),
(42, 117),
(42, 118),
(42, 119),
(42, 120),
(42, 121),
(42, 122),
(42, 123),
(42, 244),
(43, 103),
(43, 128),
(43, 151),
(43, 181),
(43, 197),
(43, 199),
(43, 207),
(44, 103),
(44, 128),
(44, 151),
(44, 181),
(44, 199),
(57, 152),
(57, 228),
(62, 103),
(63, 103),
(64, 103),
(80, 0),
(81, 0),
(130, 0),
(131, 0),
(139, 103),
(140, 103),
(141, 103),
(142, 103),
(143, 103),
(163, 152),
(163, 228),
(166, 101),
(166, 244),
(170, -103),
(173, -103),
(175, 101),
(176, 132),
(177, 103),
(177, 128),
(177, 151),
(177, 181),
(177, 197),
(177, 199),
(177, 207),
(182, 0),
(184, 103),
(185, 103),
(186, 103),
(187, 103),
(188, 103),
(189, 103),
(191, 101),
(191, 152),
(191, 244),
(192, 101),
(192, 152),
(195, 101),
(198, 101),
(199, 101),
(200, 0),
(201, 0),
(203, 101),
(205, -103),
(206, 101),
(207, 101),
(208, 101),
(211, 101),
(212, 0),
(213, 0),
(214, 101),
(215, -103),
(216, 0),
(217, 101),
(217, 244),
(218, -103),
(219, -103),
(220, -103),
(221, 0),
(222, -244),
(222, -101);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
`id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
`id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE IF NOT EXISTS `#__postinstall_messages` (
`postinstall_message_id` bigint(20) unsigned NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(4, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(5, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(6, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(7, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(8, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(9, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(10, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1);

DROP TABLE IF EXISTS `#__privacy_consents`;
CREATE TABLE IF NOT EXISTS `#__privacy_consents` (
`id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE IF NOT EXISTS `#__privacy_requests` (
`id` int(10) unsigned NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__redirect_links`;
CREATE TABLE IF NOT EXISTS `#__redirect_links` (
`id` int(10) unsigned NOT NULL,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT '301'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=40 ;

INSERT INTO `#__redirect_links` (`id`, `old_url`, `new_url`, `referer`, `comment`, `hits`, `published`, `created_date`, `modified_date`, `header`) VALUES
(1, 'http://127.0.0.1/joomla/j2/#__setcard/index.php/joomla/other-componentsremaining-component-views/index.php', '', 'http://127.0.0.1/joomla/j2/#__setcard/index.php/joomla/other-componentsremaining-component-views/registration', '', 3, 0, '2013-06-16 20:34:07', '0000-00-00 00:00:00', 301),
(2, 'http://127.0.0.1/joomla/j2/#__setcard/index.php/icons', '', 'http://127.0.0.1/joomla/j2/#__setcard/index.php/widgetkit', '', 1, 0, '2013-06-21 12:06:52', '0000-00-00 00:00:00', 301),
(3, 'http://127.0.0.1/joomla/j2/#__setcard/index.php/features/custom-error-page', '', 'http://127.0.0.1/joomla/j2/#__setcard/', '', 2, 0, '2013-06-22 19:12:27', '0000-00-00 00:00:00', 301),
(4, 'http://127.0.0.1/joomla/j2/#__setcard/index.php/component/error/?Itemid=174', '', 'http://127.0.0.1/joomla/j2/#__setcard/', '', 2, 0, '2013-06-22 19:15:27', '0000-00-00 00:00:00', 301),
(5, 'http://127.0.0.1/joomla/j2/#__setcard/index.php?profile=blue&Itemid=177', '', 'http://127.0.0.1/joomla/j2/#__setcard/index.php?profile=pink', '', 2, 0, '2013-06-22 21:25:20', '0000-00-00 00:00:00', 301),
(6, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?option=com_error&Itemid=174', '', 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?option=com_content&view=article&id=24&Itemid=173', '', 332, 0, '2013-06-23 11:50:26', '0000-00-00 00:00:00', 301),
(7, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?option=com_jce&task=plugin&plugin=imgmanager&file=imgmanager&version=', '', '', '', 3, 0, '2013-07-30 14:52:45', '0000-00-00 00:00:00', 301),
(8, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?option=com_jce&task=plugin&plugin=imgmanager&file=imgmanager&version=1576&cid=20', '', '', '', 114, 0, '2013-09-10 08:52:00', '0000-00-00 00:00:00', 301),
(9, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?option=com_jce&task=plugin&plugin=imgmanager&file=imgmanager&method=form&cid=20&6bc427c8a7981f4fe1f5ac65c1246b5f=cf6dd3cf1923c950586d0dd595c8e20b', '', '', '', 113, 0, '2013-09-10 08:52:00', '0000-00-00 00:00:00', 301),
(10, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?amp;view=article&id=4&Itemid=104', '', '', '', 1, 0, '2013-09-22 18:16:54', '0000-00-00 00:00:00', 301),
(11, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?amp;view=article&id=24&Itemid=173', '', '', '', 1, 0, '2013-09-22 18:16:56', '0000-00-00 00:00:00', 301),
(12, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?amp;view=article&id=1&Itemid=103', '', '', '', 1, 0, '2013-09-22 18:16:58', '0000-00-00 00:00:00', 301),
(13, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?Itemid=174&option=com_error', '', '', '', 1, 0, '2013-11-01 03:28:37', '0000-00-00 00:00:00', 301),
(14, 'http://127.0.0.1/joomla/j2/#__married-warp//index.php?option=com_jce&task=plugin&plugin=imgmanager&file=imgmanager&method=form&cid=20&6bc427c8a7981f4fe1f5ac65c1246b5f=cf6dd3cf1923c950586d0dd595c8e20b', '', '', '', 1, 0, '2013-12-17 11:16:06', '0000-00-00 00:00:00', 301),
(15, 'http://127.0.0.1/joomla/j2/#__married-warp//index.php?option=com_jce&task=plugin&plugin=imgmanager&file=imgmanager&version=1576&cid=20', '', '', '', 1, 0, '2014-01-02 13:50:43', '0000-00-00 00:00:00', 301),
(16, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?amp;id=4&Itemid=104', '', '', '', 2, 0, '2014-02-26 06:50:25', '0000-00-00 00:00:00', 301),
(17, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?amp;id=24&Itemid=173', '', '', '', 2, 0, '2014-02-26 06:50:30', '0000-00-00 00:00:00', 301),
(18, 'http://127.0.0.1/joomla/j2/#__married-warp/index.php?amp;id=1&Itemid=103', '', '', '', 1, 0, '2014-02-26 06:50:32', '0000-00-00 00:00:00', 301),
(19, 'http://127.0.0.1/joomla/j2/#__flexible-warp/index.php?option=com_error&Itemid=174', '', 'http://127.0.0.1/joomla/j2/#__flexible-warp/index.php?option=com_content&view=article&id=1&Itemid=103', '', 1, 0, '2014-03-28 22:19:35', '0000-00-00 00:00:00', 301),
(20, 'http://127.0.0.1/joomla/j2/#__ultimate/index.php?option=com_error&Itemid=174', '', 'http://127.0.0.1/joomla/j2/#__ultimate/index.php?option=com_content&view=article&id=28&Itemid=102', '', 3, 0, '2014-04-25 21:04:17', '0000-00-00 00:00:00', 301),
(21, 'http://127.0.0.1/joomla/j2/#__ultimate/index.php?option=com_content&view=article&id=29&Itemid=183', '', 'http://127.0.0.1/joomla/j2/#__ultimate/index.php?option=com_content&view=article&id=28&Itemid=102', '', 1, 0, '2014-04-30 10:41:35', '0000-00-00 00:00:00', 301),
(22, 'http://127.0.0.1/joomla/j2/#__allrounder/index.php?option=com_error&Itemid=174', '', 'http://127.0.0.1/joomla/j2/#__allrounder/index.php?option=com_content&view=article&id=30&Itemid=197', '', 1, 0, '2014-11-07 01:02:36', '0000-00-00 00:00:00', 301),
(23, 'http://127.0.0.1/joomla/j2/#__1stclass/index.php?option=com_error&Itemid=174', '', 'http://127.0.0.1/joomla/j2/#__1stclass/index.php?option=com_content&view=article&id=1&Itemid=103', '', 1, 0, '2014-11-18 19:40:18', '0000-00-00 00:00:00', 301),
(24, 'http://127.0.0.1/joomla/j2/#__1stclass/index.php?option=com_content&view=article&id=32&Itemid=201', '', 'http://127.0.0.1/joomla/j2/#__1stclass/index.php?option=com_content&view=article&id=7&Itemid=101', '', 1, 0, '2014-11-18 19:52:24', '0000-00-00 00:00:00', 301),
(25, 'http://127.0.0.1/j3/snowflake/index.php?option=com_error&Itemid=174', '', 'http://127.0.0.1/j3/snowflake/index.php?option=com_content&view=article&id=28&Itemid=102', '', 1, 0, '2014-12-24 00:05:50', '0000-00-00 00:00:00', 301),
(26, 'http://127.0.0.1/j3/bike/index.php?Itemid=102', '', 'http://127.0.0.1/j3/bike/index.php/theme-features/module-variations', '', 1, 0, '2015-01-12 19:41:54', '0000-00-00 00:00:00', 301),
(27, 'http://127.0.0.1/j3/bike/index.php/theme-features/2014-03-26-01-16-14', '', 'http://127.0.0.1/j3/bike/', '', 1, 0, '2015-01-12 19:50:13', '0000-00-00 00:00:00', 301),
(28, 'http://127.0.0.1/j3/bike/index.php/theme-features/', '', 'http://127.0.0.1/j3/bike/index.php/theme-features/module-variations', '', 23, 0, '2015-01-12 22:29:02', '0000-00-00 00:00:00', 301),
(29, 'http://127.0.0.1/j3/bike/index.php/joomla/joomla-content-sidebars/', '', 'http://127.0.0.1/j3/bike/index.php/joomla/joomla-content-sidebars/joomla-content-sidebar-left', '', 7, 0, '2015-01-14 00:01:58', '0000-00-00 00:00:00', 301),
(30, 'http://127.0.0.1/j3/simple/index.php/home/none', '', 'http://127.0.0.1/j3/simple/index.php/home/slideshow-at-headerbar', '', 1, 0, '2015-05-22 20:15:44', '0000-00-00 00:00:00', 301),
(31, 'http://127.0.0.1/j3/simple/index.php/joomla/joomla-content/', '', 'http://127.0.0.1/j3/simple/index.php/joomla/joomla-content/single-article', '', 16, 0, '2015-06-05 10:35:38', '0000-00-00 00:00:00', 301),
(32, 'http://127.0.0.1/j3/inspire/index.php/joomla/joomla-content/', '', 'http://127.0.0.1/j3/inspire/index.php/joomla/joomla-content/category-blog-1-column', '', 1, 0, '2015-06-08 23:04:44', '0000-00-00 00:00:00', 301),
(33, 'http://127.0.0.1/j3/inspire/index.php/component/error/?Itemid=174', '', 'http://127.0.0.1/j3/inspire/index.php/joomla/joomla-content/category-blog-2-column', '', 2, 0, '2015-06-09 01:34:53', '0000-00-00 00:00:00', 301),
(34, 'http://localhost/warp-7/inspire/index.php/joomla/joomla-content/', '', 'http://localhost/warp-7/inspire/index.php/joomla/joomla-content/category-blog-1-column', '', 12, 0, '2015-06-24 11:07:31', '0000-00-00 00:00:00', 301),
(35, 'http://localhost/j3/wedding/index.php/theme-features/', '', 'http://localhost/j3/wedding/index.php/theme-features/module-variations', '', 10, 0, '2015-07-09 19:52:39', '0000-00-00 00:00:00', 301),
(36, 'http://localhost/j3/wedding/index.php/component/error/?Itemid=174', '', 'http://localhost/j3/wedding/index.php/theme-features/smooth-scroll-function', '', 1, 0, '2015-07-13 21:35:45', '0000-00-00 00:00:00', 301),
(37, 'http://localhost/warp-7/sounds/index.php/theme-features/', '', 'http://localhost/warp-7/sounds/index.php/theme-features/module-variations', '', 14, 0, '2015-07-31 19:24:47', '0000-00-00 00:00:00', 301),
(38, 'http://localhost/warp-7/grill/index.php/component/error/?Itemid=174', '', 'http://localhost/warp-7/grill/index.php/theme-features/typography', '', 1, 0, '2016-05-09 20:23:35', '0000-00-00 00:00:00', 301),
(39, 'http://localhost/warp-7/grill/index.php/theme-features/real-time-customizing', '', 'http://localhost/warp-7/grill/index.php', '', 2, 0, '2016-05-09 22:57:15', '0000-00-00 00:00:00', 301);

DROP TABLE IF EXISTS `#__rokcommon_configs`;
CREATE TABLE IF NOT EXISTS `#__rokcommon_configs` (
`id` int(11) NOT NULL,
  `extension` varchar(45) NOT NULL DEFAULT '',
  `type` varchar(45) NOT NULL,
  `file` varchar(256) NOT NULL,
  `priority` int(10) NOT NULL DEFAULT '10'
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=25 ;

INSERT INTO `#__rokcommon_configs` (`id`, `extension`, `type`, `file`, `priority`) VALUES
(24, 'roksprocket', 'library', '/components/com_roksprocket/lib', 10),
(23, 'roksprocket', 'container', '/components/com_roksprocket/container.xml', 10);

DROP TABLE IF EXISTS `#__roksprocket_items`;
CREATE TABLE IF NOT EXISTS `#__roksprocket_items` (
`id` int(11) NOT NULL,
  `module_id` varchar(45) NOT NULL,
  `provider` varchar(45) NOT NULL,
  `provider_id` varchar(45) NOT NULL,
  `order` int(10) unsigned NOT NULL,
  `params` text
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1585 ;

INSERT INTO `#__roksprocket_items` (`id`, `module_id`, `provider`, `provider_id`, `order`, `params`) VALUES
(1500, '198', 'joomla', '50', 8, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-009.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_45__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Digital","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1499, '198', 'joomla', '45', 7, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-008.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_45__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Photo","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1493, '198', 'joomla', '39', 1, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_39__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Retro, Digital","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1494, '198', 'joomla', '40', 2, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_40__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Paint, Retro","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1536, '199', 'simple', '1', 2, '{"_article_title":"Simple Item 1","tables_item_title":"Developer","tables_item_description":"Truly a must have","tables_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_1__params_tables_item_image''}","tables_item_class":"Really the Best ","tables_item_price":"\\u20ac 139.99","tables_item_feature_1":"Really the Best","tables_item_feature_2":"Sometimes the Best ","tables_item_feature_3":"Not Quite the Best ","tables_item_feature_4":"-none-","tables_item_link":"#","tables_item_link_text":"Buy Now","lists_item_title":"-default-","strips_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(1534, '199', 'simple', '3', 0, '{"_article_title":"Simple Item 3","tables_item_title":"Starter","tables_item_description":"This is a really cool product ","tables_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_3__params_tables_item_image''}","tables_item_class":"-none-","tables_item_price":"\\u20ac 39.66","tables_item_feature_1":"Colorful and Fun","tables_item_feature_2":"Rarely Lets You Down","tables_item_feature_3":"Environmentally Friendly ","tables_item_feature_4":"Sometimes Disappears ","tables_item_link":"#","tables_item_link_text":"Buy Now","lists_item_title":"-default-","strips_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(1535, '199', 'simple', '2', 1, '{"_article_title":"Simple Item 2","tables_item_title":"Advanced","tables_item_description":"The best product of the product","tables_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_2__params_tables_item_image''}","tables_item_class":"Better and Awesomer ","tables_item_price":"\\u20ac 59.50","tables_item_feature_1":"Feels Great ","tables_item_feature_2":"Mildly Confusing","tables_item_feature_3":"Mildly Confusing ","tables_item_feature_4":"Colorless on Wednesday ","tables_item_link":"#","tables_item_link_text":"Buy Now","lists_item_title":"-default-","strips_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","features_item_link":"-default-"}'),
(992, '200', 'joomla', '50', 8, '{"grids_item_title":"-default-","grids_item_description":"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque","grids_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_41__params_grids_item_image''}","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(990, '200', 'joomla', '44', 6, '{"grids_item_title":"-default-","grids_item_description":"-default-","grids_item_image":"-default-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(991, '200', 'joomla', '45', 7, '{"grids_item_title":"-default-","grids_item_description":"-default-","grids_item_image":"-default-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(989, '200', 'joomla', '43', 5, '{"grids_item_title":"-default-","grids_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","grids_item_image":"-none-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(988, '200', 'joomla', '42', 4, '{"grids_item_title":"-default-","grids_item_description":"-default-","grids_item_image":"-none-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(986, '200', 'joomla', '40', 2, '{"grids_item_title":"-default-","grids_item_description":"-default-","grids_item_image":"-default-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(987, '200', 'joomla', '41', 3, '{"grids_item_title":"-default-","grids_item_description":"-default-","grids_item_image":"-none-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(984, '200', 'joomla', '38', 0, '{"grids_item_title":"-default-","grids_item_description":"-default-","grids_item_image":"-none-","grids_item_link":"-default-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(985, '200', 'joomla', '39', 1, '{"grids_item_title":"-default-","grids_item_description":"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque","grids_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_39__params_grids_item_image''}","grids_item_link":"#","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","mosaic_item_title":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1037, '201', 'joomla', '50', 8, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-009.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_45__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Webdesign","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1036, '201', 'joomla', '45', 7, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-008.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_45__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Webdesign","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1035, '201', 'joomla', '44', 6, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-007.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_44__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Photography","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1034, '201', 'joomla', '43', 5, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-006.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_43__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Mobile","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1033, '201', 'joomla', '42', 4, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-005.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_42__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Photography","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1031, '201', 'joomla', '40', 2, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_40__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Photography","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1029, '201', 'joomla', '38', 0, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_38__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Webdesign","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1030, '201', 'joomla', '39', 1, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_39__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Mobile","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}');
INSERT INTO `#__roksprocket_items` (`id`, `module_id`, `provider`, `provider_id`, `order`, `params`) VALUES
(1032, '201', 'joomla', '41', 3, '{"mosaic_item_title":"-default-","mosaic_item_description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-004.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_41__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Webdesign","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1497, '198', 'joomla', '43', 5, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-006.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_43__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Nature, Digital, Paint","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1498, '198', 'joomla', '44', 6, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-007.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_44__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Photo","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1496, '198', 'joomla', '42', 4, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-005.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_42__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Photo, Paint","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1495, '198', 'joomla', '41', 3, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-004.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_41__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Digital, Photo","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1492, '198', 'joomla', '38', 0, '{"mosaic_item_title":"-default-","mosaic_item_description":"-default-","mosaic_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_38__params_mosaic_item_image''}","mosaic_item_link":"-default-","mosaic_item_tags":"Digital, Retro","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1281, '206', 'simple', '3', 1, '{"_article_title":"Simple Item 3","quotes_item_description":"This is a sample quote!","quotes_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/team-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_3__params_quotes_item_image''}","quotes_item_author":"Sandra P.","quotes_item_subtext":"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. ","quotes_item_link":"-default-","quotes_item_direction":"-bottomleft-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1283, '206', 'simple', '1', 3, '{"_article_title":"Simple Item 1","quotes_item_description":"This is a sample quote!","quotes_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/team-004.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_1__params_quotes_item_image''}","quotes_item_author":"Jasmin S.","quotes_item_subtext":"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. ","quotes_item_link":"-default-","quotes_item_direction":"-bottomleft-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1282, '206', 'simple', '2', 2, '{"_article_title":"Simple Item 2","quotes_item_description":"This is a sample quote!","quotes_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/team-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_2__params_quotes_item_image''}","quotes_item_author":"J\\u00f6rg","quotes_item_subtext":"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. ","quotes_item_link":"-default-","quotes_item_direction":"-bottomleft-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1280, '206', 'simple', '4', 0, '{"_article_title":"Simple Item 4","quotes_item_description":"This is a sample quote!","quotes_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/team-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_4__params_quotes_item_image''}","quotes_item_author":"Luisa M.","quotes_item_subtext":"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.","quotes_item_link":"-default-","quotes_item_direction":"-bottomleft-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1574, '166', 'simple', '2', 1, '{"_article_title":"Simple Item 2","features_item_title":"Sample Headline","features_item_description":"Powerful design elements and a strict grid give the theme an organized layout that is a pleasure to read. This template is also fully responsive, meaning that the design will adapt to mobile phones and tablets for a more intuitive browsing experience. ","features_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/slideshow-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_2__params_features_item_image''}","features_item_link":"#","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1572, '211', 'joomla', '50', 8, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-009.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_50__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1571, '211', 'joomla', '45', 7, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-008.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_45__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1570, '211', 'joomla', '44', 6, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-007.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_44__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1569, '211', 'joomla', '43', 5, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-006.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_43__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1568, '211', 'joomla', '42', 4, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-005.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_42__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1567, '211', 'joomla', '41', 3, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-004.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_41__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1566, '211', 'joomla', '40', 2, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_40__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1565, '211', 'joomla', '39', 1, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_39__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1564, '211', 'joomla', '38', 0, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_38__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1584, '217', 'joomla', '50', 8, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-009.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_50__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1583, '217', 'joomla', '45', 7, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-008.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_45__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1582, '217', 'joomla', '44', 6, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-007.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_44__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1581, '217', 'joomla', '43', 5, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-006.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_43__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1580, '217', 'joomla', '42', 4, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-005.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_42__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}');
INSERT INTO `#__roksprocket_items` (`id`, `module_id`, `provider`, `provider_id`, `order`, `params`) VALUES
(1579, '217', 'joomla', '41', 3, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-004.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_41__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1578, '217', 'joomla', '40', 2, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_40__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1577, '217', 'joomla', '39', 1, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-002.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_39__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1576, '217', 'joomla', '38', 0, '{"strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_joomla_38__params_strips_item_image''}","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1516, '219', 'simple', '3', 0, '{"_article_title":"Simple Item 3","strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-010.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_3__params_strips_item_image''}","strips_item_link":"#","strips_item_description":"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor.","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1518, '219', 'simple', '1', 2, '{"_article_title":"Simple Item 1","strips_item_title":"-default-","strips_item_image":"-default-","strips_item_link":"-default-","strips_item_description":"-default-","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1517, '219', 'simple', '2', 1, '{"_article_title":"Simple Item 2","strips_item_title":"-default-","strips_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/demo-009.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_2__params_strips_item_image''}","strips_item_link":"#","strips_item_description":"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor.","lists_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","features_item_title":"-default-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","features_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","features_item_image":"-default-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","features_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1573, '166', 'simple', '1', 0, '{"_article_title":"Simple Item 1","features_item_title":"City Professional Joomla Template","features_item_description":"Our new \\"City\\" Joomla Template is dedicated for travel companies or any other clean business sites. The theme is a sleek and modern Joomla design that does a great job displaying tons of content while at the same time avoiding the feeling of clutter.","features_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/slideshow-001.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_1__params_features_item_image''}","features_item_link":"#","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","tables_item_link_text":"Buy Now"}'),
(1575, '222', 'simple', '2', 0, '{"_article_title":"Simple Item 2","features_item_title":"-none-","features_item_description":"-none-","features_item_image":"{''type'':''mediamanager'',''path'':''images\\/joomlaplates\\/slideshow-003.jpg'',''preview'':'''',''link'':''index.php?option=com_media&view=images&layout=default&tmpl=component&e_name=items_simple_2__params_features_item_image''}","features_item_link":"-none-","lists_item_title":"-default-","strips_item_title":"-default-","tables_item_title":"-default-","tabs_item_title":"-default-","grids_item_title":"-default-","mosaic_item_title":"-default-","grids_item_description":"-default-","quotes_item_description":"-default-","tables_item_description":"-default-","tabs_item_icon":"-default-","mosaic_item_description":"-default-","grids_item_image":"-default-","tabs_item_link":"-default-","lists_item_image":"-default-","quotes_item_image":"-default-","tables_item_image":"-default-","strips_item_image":"-default-","mosaic_item_image":"-default-","lists_item_link":"-default-","tables_item_class":"-none-","grids_item_link":"-default-","tabs_item_description":"-default-","quotes_item_author":"-none-","mosaic_item_link":"-default-","strips_item_link":"-default-","tables_item_feature_1":"-none-","tables_item_price":"-none-","tables_item_feature_2":"-none-","sliders_item_title":"-default-","quotes_item_subtext":"-none-","mosaic_item_tags":"-article-","headlines_item_image":"-default-","strips_item_description":"-default-","lists_item_description":"-default-","sliders_item_description":"-default-","quotes_item_link":"-default-","tables_item_feature_3":"-none-","sliders_item_image":"-default-","quotes_item_direction":"-bottomleft-","headlines_item_link":"-default-","tables_item_feature_4":"-none-","sliders_item_link":"-default-","headlines_item_description":"-default-","tables_item_link":"-default-","tables_item_link_text":"Buy Now"}');

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE IF NOT EXISTS `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.9.3-2019-02-07');

DROP TABLE IF EXISTS `#__session`;
CREATE TABLE IF NOT EXISTS `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint(3) unsigned DEFAULT NULL,
  `guest` tinyint(3) unsigned DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__session` (`session_id`, `client_id`, `guest`, `time`, `data`, `userid`, `username`) VALUES
(0x6d726e6c6e6d3463706f38636a303973686b31766c726c756c6b, 0, 1, 1559571424, 'joomla|s:860:"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjE6e3M6OToiX19kZWZhdWx0IjtPOjg6InN0ZENsYXNzIjozOntzOjc6InNlc3Npb24iO086ODoic3RkQ2xhc3MiOjM6e3M6NzoiY291bnRlciI7aToxO3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTU1OTU3MTQxOTtzOjQ6Imxhc3QiO2k6MTU1OTU3MTQxOTtzOjM6Im5vdyI7aToxNTU5NTcxNDE5O31zOjU6InRva2VuIjtzOjMyOiJydExXaWlBNUFUd09SbDdSTDZrSzd5VXEwNFpyRHo4USI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjoxOntzOjEzOiJjb21faW5zdGFsbGVyIjtPOjg6InN0ZENsYXNzIjoyOntzOjc6Im1lc3NhZ2UiO3M6MDoiIjtzOjE3OiJleHRlbnNpb25fbWVzc2FnZSI7czowOiIiO319czoxNDoiACoAaW5pdGlhbGl6ZWQiO2I6MDtzOjk6InNlcGFyYXRvciI7czoxOiIuIjt9czo0OiJ1c2VyIjtPOjIwOiJKb29tbGFcQ01TXFVzZXJcVXNlciI6MTp7czoyOiJpZCI7aTowO319fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==";', 0, ''),
(0x6339316670626d693638716a7437757132337363353230746864, 1, 0, 1559571987, 'joomla|s:1036:"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjE6e3M6OToiX19kZWZhdWx0IjtPOjg6InN0ZENsYXNzIjo0OntzOjc6InNlc3Npb24iO086ODoic3RkQ2xhc3MiOjM6e3M6NzoiY291bnRlciI7aToxMTtzOjU6InRpbWVyIjtPOjg6InN0ZENsYXNzIjozOntzOjU6InN0YXJ0IjtpOjE1NTk1NzE0Mzg7czo0OiJsYXN0IjtpOjE1NTk1NzE5ODQ7czozOiJub3ciO2k6MTU1OTU3MTk4Njt9czo1OiJ0b2tlbiI7czozMjoibXBsS25mYW4xNWhNdXVRZ1RNMkp3VVZ6T0tPc2RhM1AiO31zOjg6InJlZ2lzdHJ5IjtPOjI0OiJKb29tbGFcUmVnaXN0cnlcUmVnaXN0cnkiOjM6e3M6NzoiACoAZGF0YSI7Tzo4OiJzdGRDbGFzcyI6Mjp7czoxMzoiY29tX2luc3RhbGxlciI7Tzo4OiJzdGRDbGFzcyI6Mjp7czo3OiJtZXNzYWdlIjtzOjA6IiI7czoxNzoiZXh0ZW5zaW9uX21lc3NhZ2UiO3M6MDoiIjt9czoxNjoiY29tX2pvb21sYXVwZGF0ZSI7Tzo4OiJzdGRDbGFzcyI6MTp7czo2OiJtZXRob2QiO3M6NjoiZGlyZWN0Ijt9fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fXM6NDoidXNlciI7TzoyMDoiSm9vbWxhXENNU1xVc2VyXFVzZXIiOjE6e3M6MjoiaWQiO3M6MzoiNTE5Ijt9czoxMToiYXBwbGljYXRpb24iO086ODoic3RkQ2xhc3MiOjE6e3M6NToicXVldWUiO2E6MDp7fX19fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==";', 519, '12');

DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE IF NOT EXISTS `#__tags` (
`id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES
(1, 0, 0, 1, 0, '', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 519, '2011-01-01 00:00:01', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE IF NOT EXISTS `#__template_styles` (
`id` int(10) unsigned NOT NULL,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=35 ;

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES
(20, 'protostar', 0, '0', 'protostar - Default', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}'),
(21, 'isis', 1, '1', 'isis - Default', '{"templateColor":"","logoFile":""}'),
(30, 'jp-exchange', 0, '0', 'jp-exchange - Default', '{"config":""}'),
(31, 'jp-city', 0, '1', 'jp-city - Default', '{"config":""}'),
(32, 'beez3', 0, '0', 'beez3 - Default', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature","backgroundcolor":"#eee"}'),
(33, 'hathor', 1, '0', 'Hathor Administrator template - Default', '{"showSiteName":"0","logoFile":"","colourChoice":"0","boldText":"0"}'),
(34, 'bluestork', 1, '0', 'Bluestork Administrator Template - Default', '{"showSiteName":"0","textBig":"0","highContrast":"0"}');

DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE IF NOT EXISTS `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE IF NOT EXISTS `#__ucm_content` (
`core_content_id` int(10) unsigned NOT NULL,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields' AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__ucm_history`;
CREATE TABLE IF NOT EXISTS `#__ucm_history` (
`version_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__updates`;
CREATE TABLE IF NOT EXISTS `#__updates` (
`update_id` int(11) NOT NULL,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT ''
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates' AUTO_INCREMENT=33 ;

INSERT INTO `#__updates` (`update_id`, `update_site_id`, `extension_id`, `name`, `description`, `element`, `type`, `folder`, `client_id`, `version`, `data`, `detailsurl`, `infourl`, `extra_query`) VALUES
(3, 4, 0, 'RokCommon Plugin', '', '', 'plugin', '', 0, '3.2.7', '0802', 'http://updates.rockettheme.com/joomla/138/2084920890', '', ''),
(4, 4, 0, 'RokGallery Extension', '', 'mod_rokgallery', 'module', '', 0, '2.45', '0802', 'http://updates.rockettheme.com/joomla/286/21ffe006', '', ''),
(5, 4, 0, 'RokCommon Plugin', '', '', 'plugin', '', 0, '3.2.7', '0802', 'http://updates.rockettheme.com/joomla/286/326466299', '', ''),
(6, 4, 0, 'RokBooster Plugin', '', 'rokbooster', 'plugin', 'system', 0, '1.1.18', '0802', 'http://updates.rockettheme.com/joomla/287/cb577720', '', ''),
(7, 4, 0, 'RokAjaxSearch Module', '', 'mod_rokajaxsearch', 'module', '', 0, '2.0.6', '0802', 'http://updates.rockettheme.com/joomla/290/1d5a0af1', '', ''),
(8, 4, 0, 'RokWeather Module', '', 'mod_rokweather', 'module', '', 0, '2.0.4', '0802', 'http://updates.rockettheme.com/joomla/292/a0cbba72', '', ''),
(9, 4, 0, 'RokStock Module', '', 'mod_rokstock', 'module', '', 0, '2.0.3', '0802', 'http://updates.rockettheme.com/joomla/295/87c1121c', '', ''),
(10, 4, 0, 'RokMiniEvents3 Module', '', 'mod_rokminievents3', 'module', '', 0, '3.0.3', '0802', 'http://updates.rockettheme.com/joomla/297/1686051690', '', ''),
(11, 4, 0, 'RokQuickCart Extension', '', 'com_rokquickcart', 'component', '', 1, '2.1.5', '0802', 'http://updates.rockettheme.com/joomla/298/ddfa10eb', '', ''),
(13, 4, 0, 'RokNavMenu Module', '', 'mod_roknavmenu', 'module', '', 0, '2.0.9', '0802', 'http://updates.rockettheme.com/joomla/300/5a9aa468', '', ''),
(14, 4, 0, 'RokBox Plugin', '', 'rokbox', 'plugin', 'system', 0, '2.0.15', '0802', 'http://updates.rockettheme.com/joomla/301/dfc993d8', '', ''),
(15, 4, 0, 'RokCandy Extension', '', 'rokcandy', 'plugin', 'system', 0, '2.0.3', '0802', 'http://updates.rockettheme.com/joomla/302/2df8a4e2', '', ''),
(16, 4, 0, 'RokComments Plugin', '', 'rokcomments', 'plugin', 'content', 0, '2.0.3', '0802', 'http://updates.rockettheme.com/joomla/303/d1fd7b76', '', ''),
(17, 4, 0, 'RokStories Module', '', 'mod_rokstories', 'module', '', 0, '1.15', '0802', 'http://updates.rockettheme.com/joomla/313/1724592219', '', ''),
(18, 4, 0, 'RokFeatureTable Module', '', 'mod_rokfeaturetable', 'module', '', 0, '1.7', '0802', 'http://updates.rockettheme.com/joomla/313/1929450724', '', ''),
(19, 4, 0, 'RokTabs Module', '', 'mod_roktabs', 'module', '', 0, '1.14', '0802', 'http://updates.rockettheme.com/joomla/313/1338024578', '', ''),
(20, 4, 0, 'RokNewsPager Module', '', 'mod_roknewspager', 'module', '', 0, '2.0.2', '0802', 'http://updates.rockettheme.com/joomla/313/632659459', '', ''),
(21, 4, 0, 'RokNewsFlash Module', '', 'mod_roknewsflash', 'module', '', 0, '2.0.1', '0802', 'http://updates.rockettheme.com/joomla/313/902599661', '', ''),
(22, 4, 0, 'RokContentRotator Module', '', 'mod_rokcontentrotator', 'module', '', 0, '2.0.2', '0802', 'http://updates.rockettheme.com/joomla/313/483184226', '', ''),
(23, 4, 0, 'RokIntroScroller Module', '', 'mod_rokintroscroller', 'module', '', 0, '1.1', '0802', 'http://updates.rockettheme.com/joomla/313/1559131823', '', ''),
(24, 4, 0, 'RokStock', '', '', 'module', '', 0, '2.0.3', '0802', 'http://updates.rockettheme.com/joomla/313/983093075', '', ''),
(25, 4, 0, 'RokWeather', '', '', 'module', '', 0, '2.0.4', '0802', 'http://updates.rockettheme.com/joomla/313/1307741342', '', ''),
(26, 4, 0, 'RokQuickCart', '', '', 'component', '', 0, '2.1.5', '0802', 'http://updates.rockettheme.com/joomla/313/1089655497', '', ''),
(27, 4, 0, 'RokMiniEvents', '', '', 'module', '', 0, '3.0.3', '0802', 'http://updates.rockettheme.com/joomla/313/1301311221', '', ''),
(28, 4, 0, 'RokComments', '', '', 'plugin', '', 0, '2.0.3', '0802', 'http://updates.rockettheme.com/joomla/313/2049982768', '', ''),
(29, 4, 0, 'RokCheck (Template Version Check)', '', '', 'module', '', 1, '1.0.0', '0802', 'http://updates.rockettheme.com/joomla/381/791616223', '', ''),
(30, 4, 0, 'RokCommon Plugin', '', '', 'plugin', '', 0, '3.2.7', '0802', 'http://updates.rockettheme.com/joomla/381/337128173', '', ''),
(31, 4, 0, 'RokSocialButtons Plugin', '', 'roksocialbuttons', 'plugin', 'content', 0, '1.5.3', '0802', 'http://updates.rockettheme.com/joomla/381/269989291', '', '');

DROP TABLE IF EXISTS `#__update_sites`;
CREATE TABLE IF NOT EXISTS `#__update_sites` (
`update_site_id` int(11) NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT ''
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites' AUTO_INCREMENT=7 ;

INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`) VALUES
(1, 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', 1, 1559571985, ''),
(3, 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', 0, 0, ''),
(4, 'RocketTheme Update Directory', 'collection', 'http://updates.rockettheme.com/joomla/updates.xml', 1, 1559571661, ''),
(5, 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', 1, 1559571661, ''),
(6, 'Weblinks Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/weblinks/master/manifest.xml', 0, 0, '');

DROP TABLE IF EXISTS `#__update_sites_extensions`;
CREATE TABLE IF NOT EXISTS `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';

INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES
(1, 700),
(3, 802),
(4, 10046),
(4, 10058),
(4, 10060),
(4, 10088),
(4, 10089),
(4, 10090),
(4, 10091),
(5, 28),
(6, 801);

DROP TABLE IF EXISTS `#__viewlevels`;
CREATE TABLE IF NOT EXISTS `#__viewlevels` (
`id` int(10) unsigned NOT NULL COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES
(1, 'Public', 0, '[1]'),
(2, 'Registered', 1, '[6,2,8]'),
(3, 'Special', 2, '[6,3,8]');

DROP TABLE IF EXISTS `#__weblinks`;
CREATE TABLE IF NOT EXISTS `#__weblinks` (
`id` int(10) unsigned NOT NULL,
  `catid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `images` text NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `#__weblinks` (`id`, `catid`, `title`, `alias`, `url`, `description`, `hits`, `state`, `checked_out`, `checked_out_time`, `ordering`, `access`, `params`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `images`) VALUES
(1, 9, 'Respnsove Designs', 'respnsove-designs', 'http://www.joomlaplates.com/component/k2/content/21-responsive-layout/', '', 17, 1, 0, '0000-00-00 00:00:00', 1, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-01-22 12:45:30', 714, '', '2013-06-23 19:15:10', 667, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, ''),
(2, 9, 'Joomla 3.x Templates', 'joomla-3-x-templates', 'http://www.joomlaplates.com/component/k2/content/13-joomla-3-1-compatible/', '', 16, 1, 0, '0000-00-00 00:00:00', 2, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-01-22 12:45:46', 714, '', '2013-06-23 19:14:48', 667, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, ''),
(3, 9, 'Business Themes', 'business-themes', 'http://www.joomlaplates.com/component/k2/content/16-business-and-industry/', '', 16, 1, 0, '0000-00-00 00:00:00', 3, 1, '{"target":"","width":"","height":"","count_clicks":""}', '*', '2012-01-22 12:45:58', 714, '', '2013-06-23 19:15:31', 667, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, '');


ALTER TABLE `#__action_logs`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_user_id` (`user_id`), ADD KEY `idx_user_id_logdate` (`user_id`,`log_date`), ADD KEY `idx_user_id_extension` (`user_id`,`extension`), ADD KEY `idx_extension_item_id` (`extension`,`item_id`);

ALTER TABLE `#__action_logs_extensions`
 ADD PRIMARY KEY (`id`);

ALTER TABLE `#__action_logs_users`
 ADD PRIMARY KEY (`user_id`), ADD KEY `idx_notify` (`notify`);

ALTER TABLE `#__action_log_config`
 ADD PRIMARY KEY (`id`);

ALTER TABLE `#__assets`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_asset_name` (`name`), ADD KEY `idx_lft_rgt` (`lft`,`rgt`), ADD KEY `idx_parent_id` (`parent_id`);

ALTER TABLE `#__associations`
 ADD PRIMARY KEY (`context`,`id`), ADD KEY `idx_key` (`key`);

ALTER TABLE `#__banners`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_state` (`state`), ADD KEY `idx_own_prefix` (`own_prefix`), ADD KEY `idx_banner_catid` (`catid`), ADD KEY `idx_language` (`language`), ADD KEY `idx_metakey_prefix` (`metakey_prefix`(100));

ALTER TABLE `#__banner_clients`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_own_prefix` (`own_prefix`), ADD KEY `idx_metakey_prefix` (`metakey_prefix`(100));

ALTER TABLE `#__banner_tracks`
 ADD PRIMARY KEY (`track_date`,`track_type`,`banner_id`), ADD KEY `idx_track_date` (`track_date`), ADD KEY `idx_track_type` (`track_type`), ADD KEY `idx_banner_id` (`banner_id`);

ALTER TABLE `#__categories`
 ADD PRIMARY KEY (`id`), ADD KEY `cat_idx` (`extension`,`published`,`access`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_left_right` (`lft`,`rgt`), ADD KEY `idx_language` (`language`), ADD KEY `idx_path` (`path`(100)), ADD KEY `idx_alias` (`alias`(100));

ALTER TABLE `#__contact_details`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`published`), ADD KEY `idx_catid` (`catid`), ADD KEY `idx_createdby` (`created_by`), ADD KEY `idx_featured_catid` (`featured`,`catid`), ADD KEY `idx_language` (`language`), ADD KEY `idx_xreference` (`xreference`);

ALTER TABLE `#__content`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`state`), ADD KEY `idx_catid` (`catid`), ADD KEY `idx_createdby` (`created_by`), ADD KEY `idx_featured_catid` (`featured`,`catid`), ADD KEY `idx_language` (`language`), ADD KEY `idx_xreference` (`xreference`), ADD KEY `idx_alias` (`alias`(191));

ALTER TABLE `#__contentitem_tag_map`
 ADD UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`), ADD KEY `idx_tag_type` (`tag_id`,`type_id`), ADD KEY `idx_date_id` (`tag_date`,`tag_id`), ADD KEY `idx_core_content_id` (`core_content_id`);

ALTER TABLE `#__content_frontpage`
 ADD PRIMARY KEY (`content_id`);

ALTER TABLE `#__content_rating`
 ADD PRIMARY KEY (`content_id`);

ALTER TABLE `#__content_types`
 ADD PRIMARY KEY (`type_id`), ADD KEY `idx_alias` (`type_alias`(100));

ALTER TABLE `#__extensions`
 ADD PRIMARY KEY (`extension_id`), ADD KEY `element_clientid` (`element`,`client_id`), ADD KEY `element_folder_clientid` (`element`,`folder`,`client_id`), ADD KEY `extension` (`type`,`element`,`folder`,`client_id`);

ALTER TABLE `#__fields`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`state`), ADD KEY `idx_created_user_id` (`created_user_id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_context` (`context`(191)), ADD KEY `idx_language` (`language`);

ALTER TABLE `#__fields_categories`
 ADD PRIMARY KEY (`field_id`,`category_id`);

ALTER TABLE `#__fields_groups`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`state`), ADD KEY `idx_created_by` (`created_by`), ADD KEY `idx_access` (`access`), ADD KEY `idx_context` (`context`(191)), ADD KEY `idx_language` (`language`);

ALTER TABLE `#__fields_values`
 ADD KEY `idx_field_id` (`field_id`), ADD KEY `idx_item_id` (`item_id`(191));

ALTER TABLE `#__finder_filters`
 ADD PRIMARY KEY (`filter_id`);

ALTER TABLE `#__finder_links`
 ADD PRIMARY KEY (`link_id`), ADD KEY `idx_type` (`type_id`), ADD KEY `idx_md5` (`md5sum`), ADD KEY `idx_url` (`url`(75)), ADD KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`), ADD KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`), ADD KEY `idx_title` (`title`(100));

ALTER TABLE `#__finder_links_terms0`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms1`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms2`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms3`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms4`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms5`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms6`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms7`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms8`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_terms9`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_termsa`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_termsb`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_termsc`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_termsd`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_termse`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_links_termsf`
 ADD PRIMARY KEY (`link_id`,`term_id`), ADD KEY `idx_term_weight` (`term_id`,`weight`), ADD KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`);

ALTER TABLE `#__finder_taxonomy`
 ADD PRIMARY KEY (`id`), ADD KEY `parent_id` (`parent_id`), ADD KEY `state` (`state`), ADD KEY `ordering` (`ordering`), ADD KEY `access` (`access`), ADD KEY `idx_parent_published` (`parent_id`,`state`,`access`);

ALTER TABLE `#__finder_taxonomy_map`
 ADD PRIMARY KEY (`link_id`,`node_id`), ADD KEY `link_id` (`link_id`), ADD KEY `node_id` (`node_id`);

ALTER TABLE `#__finder_terms`
 ADD PRIMARY KEY (`term_id`), ADD UNIQUE KEY `idx_term` (`term`), ADD KEY `idx_term_phrase` (`term`,`phrase`), ADD KEY `idx_stem_phrase` (`stem`,`phrase`), ADD KEY `idx_soundex_phrase` (`soundex`,`phrase`);

ALTER TABLE `#__finder_terms_common`
 ADD KEY `idx_word_lang` (`term`,`language`), ADD KEY `idx_lang` (`language`);

ALTER TABLE `#__finder_tokens`
 ADD KEY `idx_word` (`term`), ADD KEY `idx_context` (`context`);

ALTER TABLE `#__finder_tokens_aggregate`
 ADD KEY `token` (`term`), ADD KEY `keyword_id` (`term_id`);

ALTER TABLE `#__finder_types`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `title` (`title`);

ALTER TABLE `#__languages`
 ADD PRIMARY KEY (`lang_id`), ADD UNIQUE KEY `idx_sef` (`sef`), ADD UNIQUE KEY `idx_langcode` (`lang_code`), ADD KEY `idx_access` (`access`), ADD KEY `idx_ordering` (`ordering`);

ALTER TABLE `#__menu`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`), ADD KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`), ADD KEY `idx_menutype` (`menutype`), ADD KEY `idx_left_right` (`lft`,`rgt`), ADD KEY `idx_language` (`language`), ADD KEY `idx_alias` (`alias`(100)), ADD KEY `idx_path` (`path`(100));

ALTER TABLE `#__menu_types`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_menutype` (`menutype`);

ALTER TABLE `#__messages`
 ADD PRIMARY KEY (`message_id`), ADD KEY `useridto_state` (`user_id_to`,`state`);

ALTER TABLE `#__messages_cfg`
 ADD UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`);

ALTER TABLE `#__modules`
 ADD PRIMARY KEY (`id`), ADD KEY `published` (`published`,`access`), ADD KEY `newsfeeds` (`module`,`published`), ADD KEY `idx_language` (`language`);

ALTER TABLE `#__modules_menu`
 ADD PRIMARY KEY (`moduleid`,`menuid`);

ALTER TABLE `#__newsfeeds`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`published`), ADD KEY `idx_catid` (`catid`), ADD KEY `idx_createdby` (`created_by`), ADD KEY `idx_language` (`language`), ADD KEY `idx_xreference` (`xreference`);

ALTER TABLE `#__overrider`
 ADD PRIMARY KEY (`id`);

ALTER TABLE `#__postinstall_messages`
 ADD PRIMARY KEY (`postinstall_message_id`);

ALTER TABLE `#__privacy_consents`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_user_id` (`user_id`);

ALTER TABLE `#__privacy_requests`
 ADD PRIMARY KEY (`id`);

ALTER TABLE `#__redirect_links`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_link_modifed` (`modified_date`), ADD KEY `idx_old_url` (`old_url`(100));

ALTER TABLE `#__rokcommon_configs`
 ADD PRIMARY KEY (`id`);

ALTER TABLE `#__roksprocket_items`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_module` (`module_id`), ADD KEY `idx_module_order` (`module_id`,`order`);

ALTER TABLE `#__schemas`
 ADD PRIMARY KEY (`extension_id`,`version_id`);

ALTER TABLE `#__session`
 ADD PRIMARY KEY (`session_id`), ADD KEY `userid` (`userid`), ADD KEY `time` (`time`);

ALTER TABLE `#__tags`
 ADD PRIMARY KEY (`id`), ADD KEY `tag_idx` (`published`,`access`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_left_right` (`lft`,`rgt`), ADD KEY `idx_language` (`language`), ADD KEY `idx_path` (`path`(100)), ADD KEY `idx_alias` (`alias`(100));

ALTER TABLE `#__template_styles`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_template` (`template`), ADD KEY `idx_home` (`home`);

ALTER TABLE `#__ucm_base`
 ADD PRIMARY KEY (`ucm_id`), ADD KEY `idx_ucm_item_id` (`ucm_item_id`), ADD KEY `idx_ucm_type_id` (`ucm_type_id`), ADD KEY `idx_ucm_language_id` (`ucm_language_id`);

ALTER TABLE `#__ucm_content`
 ADD PRIMARY KEY (`core_content_id`), ADD KEY `tag_idx` (`core_state`,`core_access`), ADD KEY `idx_access` (`core_access`), ADD KEY `idx_language` (`core_language`), ADD KEY `idx_modified_time` (`core_modified_time`), ADD KEY `idx_created_time` (`core_created_time`), ADD KEY `idx_core_modified_user_id` (`core_modified_user_id`), ADD KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`), ADD KEY `idx_core_created_user_id` (`core_created_user_id`), ADD KEY `idx_core_type_id` (`core_type_id`), ADD KEY `idx_alias` (`core_alias`(100)), ADD KEY `idx_title` (`core_title`(100)), ADD KEY `idx_content_type` (`core_type_alias`(100));

ALTER TABLE `#__ucm_history`
 ADD PRIMARY KEY (`version_id`), ADD KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`), ADD KEY `idx_save_date` (`save_date`);

ALTER TABLE `#__updates`
 ADD PRIMARY KEY (`update_id`);

ALTER TABLE `#__update_sites`
 ADD PRIMARY KEY (`update_site_id`);

ALTER TABLE `#__update_sites_extensions`
 ADD PRIMARY KEY (`update_site_id`,`extension_id`);

ALTER TABLE `#__viewlevels`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_assetgroup_title_lookup` (`title`);

ALTER TABLE `#__weblinks`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`state`), ADD KEY `idx_catid` (`catid`), ADD KEY `idx_createdby` (`created_by`), ADD KEY `idx_featured_catid` (`featured`,`catid`), ADD KEY `idx_language` (`language`), ADD KEY `idx_xreference` (`xreference`);


ALTER TABLE `#__action_logs`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__action_logs_extensions`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__action_log_config`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__assets`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',AUTO_INCREMENT=210;
ALTER TABLE `#__banners`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__banner_clients`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__categories`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=13;
ALTER TABLE `#__contact_details`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
ALTER TABLE `#__content`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=60;
ALTER TABLE `#__content_types`
MODIFY `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=10005;
ALTER TABLE `#__extensions`
MODIFY `extension_id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=10092;
ALTER TABLE `#__fields`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__fields_groups`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__finder_filters`
MODIFY `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__finder_links`
MODIFY `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__finder_taxonomy`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
ALTER TABLE `#__finder_terms`
MODIFY `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__finder_types`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__languages`
MODIFY `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
ALTER TABLE `#__menu`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=247;
ALTER TABLE `#__menu_types`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;
ALTER TABLE `#__messages`
MODIFY `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__modules`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=223;
ALTER TABLE `#__newsfeeds`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__overrider`
MODIFY `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key';
ALTER TABLE `#__postinstall_messages`
MODIFY `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=11;
ALTER TABLE `#__privacy_consents`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__privacy_requests`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__redirect_links`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=40;
ALTER TABLE `#__rokcommon_configs`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=25;
ALTER TABLE `#__roksprocket_items`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=1585;
ALTER TABLE `#__tags`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
ALTER TABLE `#__template_styles`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=35;
ALTER TABLE `#__ucm_content`
MODIFY `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__ucm_history`
MODIFY `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT;
ALTER TABLE `#__updates`
MODIFY `update_id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=33;
ALTER TABLE `#__update_sites`
MODIFY `update_site_id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=7;
ALTER TABLE `#__viewlevels`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',AUTO_INCREMENT=4;
ALTER TABLE `#__weblinks`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
